# -*- coding: UTF-8 -*-
import re
import cliResource
import java.lang.Exception as JException

HOST_CMD_TIMEOUT = 5 * 60

CLI_RET_END_FLAG = ":/>"
RESULT_NOCHECK = "NOCHECK"
RESULT_NOSUPPORT = "NOSUPPORT"
RESULT_WARNING = "WARNING"
TIMEOUT_PLACE_HOLDER = "TOOLKIT_SEND_CMD_TIME_OUT"

def getMsg(lang, msg, args="", resource=cliResource.MESSAGES_DICT):
    '''
    @summary: 消息国际化
    @param lang: 语言lang
    @param msg: 消息
    @param args: 消息参数
    @param resource: 消息字典
    @return: 经过国际化处理后的消息
    '''
    errMsg = "\n--"

    try:
        if not resource.has_key(msg):
            return errMsg

        localeDict = resource.get(msg)
        if not localeDict.has_key(lang):
            return errMsg

        localeMsg = localeDict.get(lang)
        if "%s" in localeMsg or "%i" in localeMsg:
            return localeMsg % args
        else:
            return localeMsg

    except:
        return errMsg
    
def getHorizontalCliRet(cliRet):
    '''
    @summary: 按逐行字典的方式获取水平表格形式的cli回显集合
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    try:
        headline = ""
        i = 0
        cliRetList = cliRet.encode("utf8").splitlines()
        for line in cliRetList:
            reg_headline = re.compile("^\s*-+(\s+-+)*\s*$")
            match_headline = reg_headline.search(line)
            if match_headline:
                headline = match_headline.group()
                break
            i += 1
        if headline == "" or i == 0 or i >= len(cliRetList) - 1:
            return []

        title = cliRetList[i - 1]
        field_words = cliRetList[(i + 1):]
        reg_split = re.compile("\s*-+\s*")
        tuple_idxs = []
        start_pos = 0
        end_pos = 0

        while (start_pos <= len(headline)):
            match = reg_split.search(headline, start_pos)
            if match:
                end_pos = match.end()
                tuple_idxs.append((start_pos, end_pos))
                start_pos = end_pos
            else:
                break

        keys = []
        for item in tuple_idxs:
            key = title[item[0]:item[1]].strip()
            if keys.count(key):
                key += "_" + str(str(keys).count(key + "_") + 1)
            keys.append(key.decode("utf8"))

        requiredLineLen = tuple_idxs[-1][0]
        dictList = []
        for line in field_words:
            if CLI_RET_END_FLAG in line:
                break

            #标题换行的场景
            if re.search("^-+(\s+-+)*\s*$", line):
                continue

            if len(line.strip()) == 0:
                continue

            if len(line) <= requiredLineLen:
                continue

            vals = []
            for item in tuple_idxs:
                vals.append(line[item[0]:item[1]].strip().decode("utf8"))
            dictList.append(dict(zip(keys, vals)))

        return dictList
    except:
        return []



def getVerticalCliRet(cliRet):
    '''
    @summary: 按逐行字典的方式获取垂直表格形式的cli回显集合
    @param cliRet: cli回显
    @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
    '''
    cliRetList = cliRet.encode("utf8").splitlines()
    dictList = []
    lineDict = {}
    for line in cliRetList:
        if CLI_RET_END_FLAG in line:
            break

        if re.search("^-+\r*\n*$", line):
            dictList.append(lineDict.copy())
            lineDict.clear()

        fields = line.split(" : ")
        if len(fields) < 2:
            continue

        key = fields[0].strip().decode("utf8")
        value = ":".join(fields[1:len(fields)]).strip().decode("utf8")

        if lineDict.has_key(key):
            key += "_" + str(str(lineDict.keys()).count(key + "_") + 1)
        lineDict.setdefault(key, value)

    if len(lineDict) > 0:
        dictList.append(lineDict.copy())

    return dictList
def executeHostCmd(context, ssh, command, timeout=HOST_CMD_TIMEOUT):
    '''
    @summary:获取单一命令执行结果
    @param ssh: ssh 
    @param command : shell 命令
    @return: (command execute whether or not success, command result, error message) 
    '''  
    excuteSuccess = False
    errMsg = ''
    LANG = context.get("lang")
    cliRet = ssh.execCmdWithTimout(command, timeout)
    regx = ["toolkit_send_cmd_time_out", "toolkit_exe_cmd_failed"]
    if filter(lambda x : x in cliRet.lower(), regx):
        if "en" == LANG:
            errMsg += command + ":\texecute failed\r\n"
        else:
            errMsg += command + u":\t执行失败\r\n"
    else:
        if "en" == LANG:
            errMsg += command + ":\texecute success\r\n"
        else:
            errMsg += command + u":\t执行成功\r\n" 
        excuteSuccess = True
    return excuteSuccess, cliRet, errMsg

def executeCmdWithTimeout(ssh_con, cmd, LOGGER, timeout = HOST_CMD_TIMEOUT):
    '''
    @summary: execute command with time out parameters
    '''
    cli_ret = ''
    try:
        cli_ret = ssh_con.execCmdWithTimout(cmd, HOST_CMD_TIMEOUT)
        if TIMEOUT_PLACE_HOLDER in cli_ret:
            return False, cli_ret, ''
        return True , cli_ret, ''
    except BaseException, excp:
        LOGGER.logException(excp)
        return False, cli_ret, ''
    except JException, exp:
        LOGGER.logNoPass("Java.lang.exception: " + unicode(exp.toString()))
        return False, cli_ret, ''
