# -*- coding: UTF-8 -*-
import re
import time
import decimal
import resource
import os
import logger
import traceback
import datetime
import pickle
import cliUtil
ALUA_CONFIGURED_PROPERLY = 1
ALUA_CONFIGURED_FALSELY = -1
ALUA_CONFIGURED_NOT_CHECK = 0
CLI_RET_KEY = 'cliRet'
ERROR_MSG_KEY = 'errMsg'
FLAG_KEY = 'flag'
DIR_RELATIVE_CMD = "..{}..".format(os.sep)
HYPERMETRO_DATA = "{0}tools{0}inspector{0}hypermetroData".format(os.sep)
SLEEP_TIMES = 30
PORTS_BIT_ERROR_SPEC = 60
PORTS_BIT_ERROR_INTERVAL = 30
SERIAL_NUMBER_LENGTH = 20
THRESHOLD_BBU_REMAINING_LIFETIME = 90
THRESHOLD_CONTRL_CPU_USAGE = 80

FILE_SUFFIX = "."

def getLang(py_java_env):
    '''
    @summary: 从上下文中获取lang
    @param py_java_env: 上下文对象
    @return: lang
    '''
    return py_java_env.get("lang")

def getCurDeviceInfo(py_java_env):
    """
    @summary: query the device info from java env context
    """
    dev = py_java_env.get("devInfo")
    
    return dev
    

def getMsg(lang, msg, args = ""):
    '''
    @summary: 消息国际化
    @param lang: 语言lang
    @param msg: 消息
    @param args: 消息参数
    @param resource: 消息字典
    @return: 经过国际化处理后的消息
    '''
    errMsg = "\n--"

    try:
        if not resource.MESSAGES_DICT.has_key(msg):
            return errMsg

        localeDict = resource.MESSAGES_DICT.get(msg)
        if not localeDict.has_key(lang):
            return errMsg

        localeMsg = localeDict.get(lang)
        if "%s" in localeMsg or "%i" in localeMsg:
            return localeMsg % args
        else:
            return localeMsg

    except:
        return errMsg

def changUnit2B(strValue):
    '''
    @summary: 根据传入的值转换单位为B
    @return: True/False, floatValue
    '''
    floatValue = 0.0
    try:
        if not strValue:
            return(False, floatValue)
        
        if re.search("TB" , strValue):
            floatValue = float(strValue.split('T')[0].strip()) * 1024 * 1024 * 1024 * 1024
        elif re.search("GB" , strValue):
            floatValue = float(strValue.split('G')[0].strip()) * 1024 * 1024 * 1024
        elif re.search("MB" , strValue):
            floatValue = float(strValue.split('M')[0].strip()) * 1024 * 1024
        elif re.search("KB" , strValue):
            floatValue = float(strValue.split('K')[0].strip()) * 1024
        elif re.search("B" , strValue):
            floatValue = float(strValue.split('B')[0].strip())
        else:
            return(False, floatValue)

        return(True, floatValue)
    
    except Exception:
        return (False, floatValue)
    

def changUnit2GB(strValue):
    '''
    @summary: 根据传入的值转换单位为GB
    @return: True/False, floatValue
    '''
    floatValue = 0.0
    try:
        if not strValue:
            return(False, floatValue)
        
        if re.search("TB" , strValue):
            floatValue = float(strValue.split('T')[0].strip()) * 1024
        elif re.search("GB" , strValue):
            floatValue = float(strValue.split('G')[0].strip())
        elif re.search("MB" , strValue):
            floatValue = float(strValue.split('M')[0].strip()) / 1024
        elif re.search("KB" , strValue):
            floatValue = float(strValue.split('K')[0].strip()) / 1024 / 1024
        elif re.search("B" , strValue):
            floatValue = float(strValue.split('B')[0].strip()) / 1024 / 1024 / 1024 
        else:
            return(False, floatValue)

        return(True, floatValue)
    
    except Exception:
        return (False, floatValue)    

def changUnit2GBDecimal(strValue):
    '''
    @summary: 根据传入的值转换单位为GB
    @return: True/False, floatValue
    '''
    floatValue = decimal.Decimal("0.0")
    unitValue = decimal.Decimal("1024")
    
    try:
        if not strValue:
            return(False, floatValue)
        
        if re.search("TB" , strValue):
            floatValue = decimal.Decimal(strValue.split('T')[0].strip()) * unitValue
        elif re.search("GB" , strValue):
            floatValue = decimal.Decimal(strValue.split('G')[0].strip())
        elif re.search("MB" , strValue):
            floatValue = decimal.Decimal(strValue.split('M')[0].strip()) / unitValue
        elif re.search("KB" , strValue):
            floatValue = decimal.Decimal(strValue.split('K')[0].strip()) / unitValue / unitValue
        elif re.search("B" , strValue):
            floatValue = decimal.Decimal(strValue.split('B')[0].strip()) / unitValue / unitValue / unitValue
        elif decimal.Decimal(strValue.strip()) == decimal.Decimal("0.0"):
            return(True, floatValue)
        else:
            return(False, floatValue)

        return(True, floatValue)
    
    except Exception:
        return (False, floatValue) 

def getBaseName(file_path):
    '''
    @summary: 返回文件路径的文件名，不包含后缀
    @param file_path:文件路径
    @return: 返回不包含后缀的文件名字符串
    '''
    file_name = os.path.basename(file_path)
    if FILE_SUFFIX in file_name:
        dot_index = file_name.rindex(FILE_SUFFIX)
        return file_name[0:dot_index]
    else:
        return file_name
    
def getLogger(loggerInstance, pyFilePath):
    '''
    @summary: 获取日志类
    @param loggerInstance: logger实例
    @param pyFilePath: py文件路径
    '''
    pyFileName = getBaseName(pyFilePath)
    return logger.Logger(loggerInstance, pyFileName)

def getTimeDifference(oldTime, nowTime): 
    '''
    @summary: 获取时差，格式：（年 - 月 - 日），单位：天
    '''  
    try:
        oldTimeYear = int(oldTime.split("-")[0])
        oldTimeMonth = int(oldTime.split("-")[1])
        oldTimeDay = int(oldTime.split("-")[2])
        
        nowTimeYear = int(nowTime.split("-")[0])
        nowTimeMonth = int(nowTime.split("-")[1])
        nowTimeDay = int(nowTime.split("-")[2])
        
        timeDifference = (datetime.datetime(nowTimeYear,nowTimeMonth,nowTimeDay) - datetime.datetime(oldTimeYear,oldTimeMonth,oldTimeDay)).days
        
        return timeDifference
    
    except Exception:
        return ""
        

def reConnectionCli(cli, LOGGER):
    """
    @summary: 重新获取SSH通道
    """
    if cli is None:
        return False
    try:
        cli.reConnect()
        LOGGER.logInfo("it is afresh to connect to device by ssh gallery.")
        return True
    except:
        LOGGER.logError(str(traceback.format_exc()))
        return False
    
    
def refreshProcess(py_java_env, percentNumber, LOGGER):
    """
    @summary: 设置巡检当前进度
    """
    observer = py_java_env.get("progressObserver")
    try:
        if observer != None:
            observer.updateProgress(int(percentNumber))
    except:
        LOGGER.logInfo(str(traceback.format_exc()))
        
        
def getSnFromDevNode(devNode):
    """
    @summary: 通过DevNode.java对象获取设备SN。
    """
    return devNode.getDeviceSerialNumber()


def getIpFromDevNode(devNode):
    """
    @summary: 通过DevNode.java对象获取设备IP。
    """
    return devNode.getIp()


def getNameFromDevNode(devNode):
    """
    @summary: 通过DevNode.java对象获取设备名称。
    """
    return devNode.getDeviceName()


def getRemoteSNsFromDevNode(devNode):
    """
    @summary: 通过DevNode.java对象获取设备关联的远程设备SN。
    """
    return devNode.getRemoteSNs()

def getObjFromFile(LOGGER, devSn, cmd):
    """
    @summary: 根据设备SN获取命令执行CLI回显。
    """
    try:
        basePath = os.path.abspath(DIR_RELATIVE_CMD)
        filePath = basePath + HYPERMETRO_DATA + os.sep + devSn
        LOGGER.logInfo("testRes filePath: %s, %s" % (filePath, cmd))
        retryTimes = 5 * 60
        
        while not os.path.exists(filePath):
            retryTimes -= 1
            time.sleep(1)
            if retryTimes <= 0:
                return False, '', "Command echo is not existed, sn:[%s], cmd:[%s]" % (devSn, cmd)
        
        f = open(filePath, 'r')
        dataDict = pickle.load(f)
        f.close()
        cmdResDict = dataDict.get(cmd, {})
        LOGGER.logInfo("testRes cmdRetDict: %s" % str(cmdResDict))
        return cmdResDict.get(FLAG_KEY, True), cmdResDict.get(CLI_RET_KEY, ''), cmdResDict.get(ERROR_MSG_KEY, '')
    except:
        LOGGER.logError(str(traceback.format_exc())) 
        return False, '', 'Load command echo data file exception, file name:[%s]' % devSn


def mark_host_upadmin_hyper_metro_luns(context, sshCon, LOGGER):
    '''
    @summary: get hyperMetro luns on host whose been designated to upadmin
    '''
    used_utralpath = 1
    not_used_utralpath = 2
    echos = ''
    lun_wwn_dicts = context.get("allStrgHyprMtrLns")
    cmd = "upadm show vlun type=hypermetro"

    objectForPy = context.get("objectForPy")
    host_dict = objectForPy.get("hostUseUtralPathInitiatorDict")
    if not host_dict:
        host_dict = {}
    devNode = context.get("devInfo")
    # 主机侧FC启动器信息
    hostFCLauncherWwns = devNode.getHostFCLauncherWwns()
    # 主机侧ISCSI启动器信息
    hostISCSILauncherWwns = devNode.getHostISCSILauncherWwns()
    if not hostFCLauncherWwns:
        hostFCLauncherWwns = []
    if not hostISCSILauncherWwns:
        hostISCSILauncherWwns = []
    fcList = list(hostFCLauncherWwns)
    iscsiList = list(hostISCSILauncherWwns)
    fcList.extend(iscsiList)
    iniList = [initiator.lower() for initiator in fcList]
    host_type = str(devNode.getDeviceName())
    isSucess, echos, resultMsg = cliUtil.executeCmdWithTimeout(sshCon, cmd, LOGGER)
    if not isSucess:
        return False, echos
    if "lun wwn"  not in echos.lower() and '-------' not in echos:
        LOGGER.logInfo("no such command or no vlun detected.")

        for ini in iniList:
            host_dict[ini] = {"isUseUtrapath": not_used_utralpath,
                              "hostType": host_type
                              }
        objectForPy.put("hostUseUtralPathInitiatorDict", host_dict)

        return False, echos
    for lun_wwn in lun_wwn_dicts:
        lun_wwn_upper = lun_wwn.upper()
        if lun_wwn_upper in echos.upper():
            if lun_wwn_dicts.get(lun_wwn).get("hostAluaStatus") == ALUA_CONFIGURED_NOT_CHECK:
                lun_wwn_dicts.get(lun_wwn)["hostAluaStatus"] = ALUA_CONFIGURED_PROPERLY
                LOGGER.logInfo("found lun(WWN: %s) matched storage devs',which is desiginated to upadmin service." % \
                           str(lun_wwn))

    for ini in iniList:
        host_dict[ini] = {"isUseUtrapath": used_utralpath,
                          "hostType": host_type
                          }
    objectForPy.put("hostUseUtralPathInitiatorDict", host_dict)

    return True, echos

def joinLines(originLines, postLines):
    """
    @summary: 将postLines追加originLines后
    """
    if not (originLines or postLines):
        return ""
    
    if not originLines:
        return postLines
    
    if not postLines:
        return originLines
    
    return "\n".join([originLines, postLines])

class UnCheckException(Exception):
    """
    @summary: 未检查异常自定义类
    """
    def __init__(self, errorMsg, cliRet, flag=None):
        self.errorMsg = errorMsg
        self.cliRet = cliRet
        self.flag = flag