# -*- coding: UTF-8 -*-

import sys
import os
scriptpath = os.path.dirname(os.path.abspath(__file__))
hostCommonPath = os.path.join(scriptpath, "..\\..\\HOST_Common")
sys.path.append(hostCommonPath)

import common
import cliUtil
import whiteListCheck

def execute(context):
    '''
            健康检查前置脚本
    '''

    lang = context.get("lang")
    logger = context.get("logger")
    LOGGER = common.getLogger(logger, __file__)
    try:
        lang = context.get("lang")
        return whiteListCheck.execute(context)
    except:
        LOGGER.logException()
        return cliUtil.RESULT_NOCHECK, "There is no information", common.getMsg(lang, "query.result.abnormal")


def execute_doradov6(context):
    '''
            健康检查前置脚本
    '''

    lang = context.get("lang")
    logger = context.get("logger")
    LOGGER = common.getLogger(logger, __file__)
    try:
        lang = context.get("lang")
        return whiteListCheck.execute_doradov6(context)
    except Exception as e:
        LOGGER.logException(e)
        return (cliUtil.RESULT_NOCHECK, "There is no information",
                common.getMsg(lang, "query.result.abnormal"))
