# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        chk_start = False
        inDeveloper = False
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""
        type = "default"
        
        
        #老版本要切换到developer下面执行
        if "V100R001C00B033" == common.getCurrentVesion(cli): 
            retInfo= common.change2Developer(cli, py_java_env)
            cliRet = retInfo[1]
            errMsg = retInfo[2]
            if not retInfo[0]:
                common.anyModel2Cli(cli)
                PY_LOGGER.info("Sequence[18] inspect not pass. (can't enter to developer model!)")
                return(False, cliRet, errMsg)  
            inDeveloper = True
            
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show port bit_error"
        PY_LOGGER.info("Sequence[18] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[18] inspect not pass. (system abnormal!)")
            if inDeveloper == True:
                common.anyModel2Cli(cli)
                inDeveloper = False
            return (False, cliRet, errMsg)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        inDeveloper = True   
        list = cliRet.splitlines()
        ethId=""
        fcId=""
        for field in list:       
            if -1!=field.find("FC port"):
                chk_start = True
                type = "fc"
                PY_LOGGER.info("Sequence[18] change flag to true~~~over!" + field)
            if field.find("ETH port") != -1:
                chk_start = True
                type = "eth"
                PY_LOGGER.info("Sequence[18] change flag to true~~~over!" + field)
            if field.find("FCoE port") != -1:
                chk_start = True
                type = "fcoe"
                PY_LOGGER.info("Sequence[18] change flag to true~~~over!" + field)
            if field.find("SAS port") != -1 or field.find("PCIE port") != -1:
                chk_start = False
                PY_LOGGER.info("Sequence[18] change flag to false~~~over!" + field)
            if chk_start == True:
                if -1!=field.find("Start Time") or -1!=field.find("Host Port"):
                    continue
                
                checkBlack = common.isLineInBlackDict(field,lang)
                if checkBlack[0]:
                    PY_LOGGER.info("Sequence[18] inspect not pass. (system abnormal!)")
                    errMsg = type+":"+checkBlack[1]
                    if inDeveloper == True:
                        common.anyModel2Cli(cli)
                        inDeveloper = False
                    return (False, cliRet, errMsg)
                
                list2 = field.split()
                if type == "eth":
                    if len(list2) < 5:
                        continue
                    
                    if -1!=field.find("-------") or -1!=field.find("ID"):
                        continue
                    
                    #巡检项检查结果优化 modified Begin
                    for indexEth in range(1, 4):
                        if "0"!=list2[indexEth] and -1==list2[indexEth].find("--"):
                            flag = False
                            ethId = list2[0]
                            if "zh" == lang:
                                errMsg += u"\n网口["+ethId+u"]存在误码。"
                            else:
                                errMsg += "\nThe ETH port ["+ethId+"] exist error bits."
                            break
                if type == "fc":
                    if len(list2) < 6 or len(list2) >= 12:
                        continue
                    
                    if -1!=field.find("-------") or -1!=field.find("ID"):
                        continue

                    for index in range(1, 5):
                        if "0"!=list2[index] and -1==list2[index].find("--"):
                            flag = False
                            fcId = list2[0]
                            if "zh" == lang:
                                errMsg += u"\nFC口["+ fcId+u"]存在误码"
                            else:
                                errMsg += "\nThe FC port ["+fcId+"] exist error bits"
			    break
			
                if type == "fcoe":
                    if len(list2) < 5:
                        continue
                    if field.find("--") != -1 or -1!=field.find("ID"):
                        continue
		    for index in range(1, 4):
                        if "0"!=list2[index] and -1==list2[index].find("--"):
                            flag = False
                            fcId = list2[0]
                            if "zh" == lang:
                                errMsg += u"\nFCoE口[" + fcId + u"]存在误码"
                            else:
                                errMsg += "\nThe FCoE port[" + fcId + "] exist error bits"
			    break
                      
        if inDeveloper == True:
            common.anyModel2Cli(cli)
            inDeveloper = False

        if not flag:
             PY_LOGGER.info("Sequence[18] inspect not pass.")
             
        return (flag, cliRet, errMsg)
        #巡检项检查结果优化 modified End
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[18] catch except of check host port error.")
        PY_LOGGER.error("Sequence[18] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[18] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[18] catch except of trace back:" + str(traceback.print_exc()))
        if inDeveloper == True:
            common.anyModel2Cli(cli)
            inDeveloper = False
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
