# -*- coding: UTF-8 -*-
import traceback
import common
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
       flag = True
       lang = py_java_env.get("lang")
       cliRet=""
       errMsg = ""
       cmd="show controller general"
       PY_LOGGER.info("Sequence[20] begin to inspect, exec cli command:"+str(cmd))
       #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
       checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
       cliRet = checkRet[1]
       errMsg = checkRet[2]
       if checkRet[0]:
           PY_LOGGER.info("Sequence[20] inspect not pass. (system abnormal!)")
           return (False, cliRet, errMsg)
       
       list = cliRet.splitlines()
        
       for field in list:
            field = field.replace(" ", "") 
            if field.startswith("CPUUsage"):
                usage = field.split(":")[1]
                PY_LOGGER.info("CPU Usage is: " + usage)
                if usage == "--":
                    continue
                if int(usage) > 80:
                    flag = False
                    PY_LOGGER.info("CPU Usage is: " + usage)
                    if "zh" == lang:
                        errMsg = u"\nCPU 使用率超过80%。"
                    else:
                        errMsg = "\nCPU Usage exceeded 80%."
                    return (flag, cliRet, errMsg)
       return (flag, cliRet)
                
    except Exception:
        PY_LOGGER.error("Sequence[20] catch except of trace back:" + str(traceback.print_exc()))
        return (flag, cliRet, errMsg)
