# -*- coding: UTF-8 -*-
import traceback
import common
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        chkfc_start = False
        find_flag = False
        lang = py_java_env.get("lang")
    	errMsg = ""
        list3 = []
        list4 = []
        cliRet = "default"
        cliRet = py_java_env.get("showPortGeneral")
        if None == cliRet or "default" == cliRet:
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
            #执行的CLI命令
            cmd = "show port general"
            PY_LOGGER.info("Sequence[22] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                PY_LOGGER.info("Sequence[22] inspect not pass. (system abnormal!)")
                return (False, cliRet, errMsg)
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
            py_java_env.put("showPortGeneral", cliRet)
        else:
             PY_LOGGER.info("Sequence[22] begin to inspect, get cli result form java.")
        
        #双控以下不要求有交换机     
        cmd0 = "show controller general"
        controllerCount = 0
        
        checkRet0 = common.isCliExecRetInBlackList(cli,cmd0,lang,True)
        cliRet0 = checkRet0[1]
        errMsg = checkRet0[2]
        if checkRet0[0]:
            PY_LOGGER.info("Sequence[22] inspect not pass. (system abnormal!)")
            return (False, cliRet0, errMsg)
        
        list0 = cliRet0.splitlines()
        for field in list0:
            field = field.replace(" ","")
            if field.startswith("Controller:"):
                ctrlId = field.replace("Controller:","")
                if ctrlId != "" and ctrlId != " " and (ctrlId.find("A")!=-1 or ctrlId.find("B")!=-1):
                    controllerCount = controllerCount + 1
                continue
        
        pcieCount = 0
        list = cliRet.splitlines()
        for field in list:
            if field.find("PCIE port") != -1:
                chkfc_start = True
                pcieCount =pcieCount + 1
            if field.find("FC port") != -1 or field.find("COM port") != -1 \
            or field.find("ETH port") != -1 or field.find("SAS port")!= -1 or field.find(":/>") != -1:
                chkfc_start = False
            if chkfc_start == True:
                pcieCount =pcieCount + 1
                if field.find("---") != -1 or field.find("ID") != -1 :
                    continue
                
                checkBlack = common.isLineInBlackDict(field,lang)
                if checkBlack[0]:
                    PY_LOGGER.info("Sequence[22] inspect not pass. (system abnormal!)")
                    errMsg = checkBlack[1]
                    return (False, cliRet, errMsg)
                
                list2 = field.split()
                if len(list2) < 6:
                    continue
                if list2[1] != "Normal":
                    flag = False
                    PY_LOGGER.info("Sequence[22] Normal num in A is not equal B~~~over!")
                    sasId = list2[0]
                    if 'zh' == lang:
                        errMsg += u"\nPCIE端口["+list2[0]+u"]状态异常"
                    else:
                        errMsg += "\nThe PCIE port["+list2[0]+"] is abnormal"
        
        PY_LOGGER.info("Sequence[22] pcieCount="+str(pcieCount))
        #检查PCIE端口是否存在
        if pcieCount <= 2:
            #双控以下不要求有交换机
            if controllerCount > 2:
                flag = False
                PY_LOGGER.info("Sequence[22] there is no pcie port!")
                if "zh" == lang:
                    errMsg = u"\nPCIE端口不在位"
                else:
                    errMsg = "\nThe port of PCIE does not exist"
        
        if not flag:
             PY_LOGGER.info("Sequence[2] inspect not pass.")
             
        return (flag, cliRet, errMsg) 
                                   
    except Exception, exception:
        PY_LOGGER.error("Sequence[22] catch except of when check FC port."+str(chkfc_start)+"~~~"+str(find_flag)+"~~~~over!")
        PY_LOGGER.error("Sequence[22] catch except of check disk NCQ status.")
        PY_LOGGER.error("Sequence[22] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[22] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[22] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
