# -*- coding: UTF-8 -*-
import traceback
import common
G_ITEM_NUM_CONTROLLER = 2
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        
        cmd = "show controller general"
        PY_LOGGER.info("Sequence[25] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[25] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        
        list = cliRet.splitlines()
        strList = []
        cliRetLast = ""
        
        for field in list:
            field = field.replace(" ","")
            if field.startswith("Controller"):
                temp = field.split(":")
                
                if len(temp) < 2 :
                    continue
                
                PY_LOGGER.info("Controller ID is:" + temp[1])
                strList.append(temp[1])
                
        for controllerID in strList:
            cliRet_DirtyRate = ""
            cmd = "show controller io io_type=frontEnd " + "controller_id=" + controllerID
            PY_LOGGER.info("Sequence[25] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet2 =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet_DirtyRate = checkRet2[1]
            errMsg += checkRet2[2]
            if checkRet2[0]:
                PY_LOGGER.info("Sequence[25] inspect not pass. (system abnormal!)")
                return (False, cliRet_DirtyRate, errMsg)
            
            cliRetLast = cliRetLast + cliRet_DirtyRate
            list2 = cliRet_DirtyRate.splitlines()
            
            #检测前端并发数和前端并发数最大限制是否存在
            if cliRet_DirtyRate.find("Front End IO") == -1 or cliRet_DirtyRate.find("Front End Limit") == -1:
                flag = False
                PY_LOGGER.info("The frontEnd is not find right.controllerID="+controllerID)
                if "zh" == lang:
                    errMsg += u"\n控制器"+controllerID+u"未正常查询前端并发数及其最大限制"
                else:
                    errMsg += "\nController["+controllerID+"] failed to query the number of front-end concurrent requests and the upper limit."
                continue
            
            #获取前端并发数据
            frontEnd=""
            frontEndLimit=""
            for field in list2:
                field = field.replace(" ","")
                if field.startswith("FrontEndIO:"):
                    frontEnd = field.replace("FrontEndIO:","")
                if field.startswith("FrontEndLimit:"):
                    frontEndLimit = field.replace("FrontEndLimit:","")
            
            if frontEnd == "" or frontEnd == "--" or frontEnd == " " or \
            frontEndLimit == "" or frontEndLimit == "--" or frontEndLimit == " ":
                flag = False
                PY_LOGGER.info("The frontEnd is not find right.controllerID="+controllerID)
                if "zh" == lang:
                    errMsg += u"\n控制器"+controllerID+u"未正常查询前端并发数及其最大限制"
                else:
                    errMsg += "\nController["+controllerID+"] failed to query the number of front-end concurrent requests and the upper limit."
                continue
            
            #判断数据的正确性
            if int(frontEnd) >= int(frontEndLimit):
                flag = False
                PY_LOGGER.info("The frontEnd is upper than it's limit,controllerID="+controllerID)
                if "zh" == lang:
                    errMsg += u"\n控制器"+controllerID+u"的前端并发数达到或超出其最大限制"
                else:
                    errMsg += "\nThe number of front-end concurrent requests of controller["+controllerID+"] has reached or exceeded the upper limit."
                continue
            
        if flag == False:
            PY_LOGGER.info("The frontEnd is not right.")
            
        return (flag, cliRetLast, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[25] catch except of check controller status.")
        PY_LOGGER.error("Sequence[25] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[25] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[25] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
            
        return (flag, cliRetLast, errMsg)
