# -*- coding: UTF-8 -*-
import traceback
import common
G_ITEM_NUM_CONTROLLER = 2
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        checkRet = ""
        
        cmd = "show controller general"
        PY_LOGGER.info("Sequence[26] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[26] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        
        list = cliRet.splitlines()
        strList = []
        cliRetLast = ""
        for field in list:
            field = field.replace(" ", "")
            if field.startswith("Controller"):
                temp = field.split(":")
                
                if len(temp) < 2 :
                    continue
                
                PY_LOGGER.info("Controller ID is:" + temp[1])
                strList.append(temp[1])
        for controllerID in strList:
            cliRet_DirtyRate = ""
            
            cmd = "show controller io io_type=backEnd " + "controller_id=" + controllerID
            PY_LOGGER.info("Sequence[26] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet2 =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet_DirtyRate = checkRet2[1]
            errMsg += checkRet2[2]
            if checkRet2[0]:
                PY_LOGGER.info("Sequence[26] inspect not pass. (system abnormal!)")
                return (False, cliRet_DirtyRate, errMsg)
            
            cliRetLast = cliRetLast + cliRet_DirtyRate
            list2 = cliRet_DirtyRate.splitlines()
            
            
            #检测后端并发数和后端并发数最大限制是否存在
            if cliRet_DirtyRate.find("Back End IO") == -1 or cliRet_DirtyRate.find("Back End Limit") == -1:
                flag = False
                PY_LOGGER.info("The backEnd is not find right.controllerID="+controllerID)
                if "zh" == lang:
                    errMsg += u"\n控制器"+controllerID+u"未正常查询后端并发数及其最大限制"
                else:
                    errMsg += "\nController["+controllerID+"] failed to query the number of back-end concurrent requests and the upper limit."
                continue
            
            #获取后端并发数据
            backEnd=""
            backEndLimit=""
            backEndPort=""
            for field in list2:
                field = field.replace(" ","")
                if field.find("----") != -1 or field.find("admin:") != -1:
                    backEnd=""
                    backEndLimit=""
                    backEndPort=""
                if field.startswith("BackEndIO:"):
                    backEnd = field.replace("BackEndIO:","")
                if field.startswith("PortId:"):
                    backEndPort = field.replace("PortId:","")
                if field.startswith("BackEndLimit:"):
                    backEndLimit = field.replace("BackEndLimit:","")
                    
                    if backEnd == "" or backEnd == "--" or backEnd == " " or \
                    backEndLimit == "" or backEndLimit == "--" or backEndLimit == " ":
                        flag = False
                        PY_LOGGER.info("The backEnd is not find right.controllerID="+controllerID)
                        if "zh" == lang:
                            errMsg += u"\n控制器"+controllerID+u"端口号"+backEndPort+u"未正常查询后端并发数及其最大限制"
                        else:
                            errMsg += "\nController["+controllerID+"] portID["+backEndPort+"] failed to query the number of back-end concurrent requests and the upper limit."
                        continue
                    PY_LOGGER.info("find me="+backEnd+"**"+backEndLimit)
                    #判断数据的正确性
                    if int(backEnd) >= int(backEndLimit):
                        flag = False
                        PY_LOGGER.info("The backEnd is upper than it's limit,controllerID="+controllerID)
                        if "zh" == lang:
                            errMsg += u"\n控制器"+controllerID+u"端口号"+backEndPort+u"的后端并发数达到或超出其最大限制"
                        else:
                            errMsg += "\nThe number of back-end concurrent requests of port["+backEndPort+"] on controller["+controllerID+"] has reached or exceeded the upper limit."
                    PY_LOGGER.info("errMsg is"+errMsg)
            
        if flag == False:
            PY_LOGGER.info("The backEnd is not right.")
            PY_LOGGER.info("errMsg is"+errMsg)
            
        return (flag, cliRetLast, errMsg)

    except Exception:
        PY_LOGGER.error("Sequence[26] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
            
        return (flag, cliRetLast, errMsg)
