# -*- coding: UTF-8 -*-
import traceback
import common
import re

def execute(cli):
    """
    Create date        : 2013/10/24
    Function name      : execute(cliConnection)
    Function describe  : execute check disk path
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet = ""
        errMsg = ""
        
        cmd = "show disk general |filterColumn include columnList=Multipathing,ID|filterRow column=Multipathing predict=equal_to value=A logicOp=or column=Multipathing predict=equal_to value=B"
        cmd_old = "show disk general |filterColumn include colunmList=Multipathing,ID|filterRow column=Multipathing predict=equal_to value=A logicOp=or column=Multipathing predict=equal_to value=B"
        PY_LOGGER.info("Sequence[29] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[29] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        
        #判断产品是否支持现有命令，若不支持（即出现^）则尝试老命令
        if re.search("\^", cliRet):
            checkRet = common.isCliExecRetInBlackList(cli, cmd_old, lang, True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                PY_LOGGER.info("Sequence[29] inspect not pass. (system abnormal!)")
                return (False, cliRet, errMsg)
        
        list = cliRet.splitlines()
                
        #巡检项检查结果优化 modified 20130913 Begin
        line=""
        for field in list:
            line=field.strip()
            field = field.replace(" ", "")
            
            if field.startswith("Commandexecutedsuccessfully"):
                flag = True
                return (flag, cliRet)
            if len(line) == 0:
                continue
            if line.startswith("ID") or line.startswith('---') or line.startswith('show disk general') \
                or line.startswith("***") or line.startswith("admin:"):
                continue
            flag = False
            locStr=line.split()[0]
     
            if 'zh' == lang:
                errMsg += u"\n硬盘[" + locStr+ u"] 单链路"
            else:
                errMsg += "\nThe disk [" + locStr+ "] is single path"

        if not flag:
             PY_LOGGER.info("\nSequence[20] inspect not pass.")
             
        return (flag, cliRet, errMsg)
        #巡检项检查结果优化 modified 20130913 End
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[20] catch except of check single link disk.")
        PY_LOGGER.error("Sequence[20] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[20] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[20] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
