# -*- coding: UTF-8 -*-
import traceback
import re
import common
import util

def execute(cli):
    """
    Create date        : 2012/05/18 
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    try:
        flag = True
        cliRet = ""
        errMsg = ""
        lang = py_java_env.get("lang")
        
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show bbu general"
        PY_LOGGER.info("Sequence[4] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet4Bbu = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[4] inspect not pass. (system abnormal!)")
            return (False, cliRet4Bbu, errMsg)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        #BBU不在位检查通过 modified 20140522 Begin
        #不能查到BBU状态信息
        if not (re.search("ID", cliRet4Bbu, re.IGNORECASE) and \
                re.search("Health", cliRet4Bbu, re.IGNORECASE) and \
                re.search("Running", cliRet4Bbu, re.IGNORECASE)):
            cliRet4BbuList = cliRet4Bbu.splitlines()
            #BBU不在位
            if re.search("Command executed successfully", cliRet4Bbu, re.IGNORECASE) or len(cliRet4BbuList) <= 3:
                flag = False
                PY_LOGGER.info("Sequence[4] BBU does not exist!")
                if "zh" == lang:
                    errMsg = u"\nBBU不在位。"
                else:
                    errMsg = "\nBBU does not exist."
                return (flag, cliRet4Bbu, errMsg)
        else:
            #检测BBU个数是否达标
            retTuple = common.checkBbuNum(cli, lang, errMsg, cliRet4Bbu)
            flag = retTuple[0]
            cliRet4SysInfo = retTuple[1]
            errMsg = retTuple[2]
        
            #检测BBU状态是否正常
            BbuList = util.formatStr(cliRet4Bbu)
            for i in range(len(BbuList)):
                bbuId = str(BbuList[i].get("ID"))
                bbuHealthStatus = str(BbuList[i].get("Health Status"))
                bbuRunningStatus = str(BbuList[i].get("Running Status"))
                if "Normal" != bbuHealthStatus:
                    flag = False
                    PY_LOGGER.info("Sequence[4] health status of BBU(" + bbuId + ") is abnormal(" + bbuHealthStatus + ")")
                    if "zh" == lang:
                        errMsg += u"\nBBU(" + bbuId + u")健康状态检查异常(" + bbuHealthStatus + u")"
                    else:
                        errMsg += "\nThe health status of BBU(" + bbuId + ") is abnormal(" + bbuHealthStatus + ")"
                if bbuRunningStatus.lower() not in  ["online","charging","discharging"]:
                    flag = False
                    PY_LOGGER.info("Sequence[4] running status of BBU(" + bbuId + ") is abnormal(" + bbuRunningStatus + ")")
                    if "zh" == lang:
                        errMsg += u"\nBBU(" + bbuId + u")运行状态检查异常(" + bbuRunningStatus + u")"
                    else:
                        errMsg += "\nThe running status of BBU(" + bbuId + ") is abnormal(" + bbuRunningStatus + ")"
            
        return (flag, cliRet4Bbu + cliRet4SysInfo, errMsg)
        #BBU不在位检查通过 modified 20140522 End
        #巡检项检查结果优化 modified End

    except Exception, exception:
        PY_LOGGER.error("Sequence[4] catch except of check bbu status.")
        PY_LOGGER.error("Sequence[4] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[4] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[4] catch except of trace back:" + str(traceback.format_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
