# -*- coding: UTF-8 -*-
import traceback
import common
import util

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check SES version
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        cliRet = "default"
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = py_java_env.get("showVersionAll")
        if None == cliRet or "default" == cliRet:
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
            #执行的CLI命令
            cmd = "show version all"
            PY_LOGGER.info("Sequence[44] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                PY_LOGGER.info("Sequence[44] inspect not pass. (system abnormal!)")
                return (False, cliRet, errMsg)
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
            py_java_env.put("showVersionAll", cliRet)
        else:
             PY_LOGGER.info("Sequence[44] begin to inspect, get cli result form java.")
             
        #Check controller ses vesion
        list1 = cliRet.splitlines()
            
        flashSign = "nothaveInfo"
        versionFlash = ""
        
        for field in list1:
            field = field.replace(" ", "")         
            if (1 == field.startswith("SESVersion:")) and ( flashSign == "nothaveInfo"):
                versionFlash = field.replace("SESVersion:", "")
                flashSign = "haveInfo"
            elif (1 == field.startswith("SESVersion:")) and ( flashSign == "haveInfo"):
                nowVersion = field.replace("SESVersion:", "")
                
                if versionFlash != nowVersion:
                    flag = False
                    PY_LOGGER.info("Sequence[44] inspect not pass.")
                    if "zh" == lang:
                        errMsg = u"\n控制器SES版本不一致"
                    else:
                        errMsg = "\nThe controller SES have not the same version"
                    return (flag, cliRet, errMsg)
                    break

        #Check enclosure ses vesion
        list2 = cliRet.splitlines()
        #modified 20140516 begin
        str4ExpansionInCliRet = ""
        versionEncTrace = []
        startFalg = False
        for field in list2:
            if field.startswith("Expansion"):
                startFalg = True
                continue
            if field.startswith("BBU:"):
                startFalg = False
            if startFalg:
                str4ExpansionInCliRet += field + "\n"
        
        expansionList = util.formatStr(str4ExpansionInCliRet)
        for i in range(len(expansionList)):
            str4ExpVersion = expansionList[i].get("SES Version")
            str4ExpId = expansionList[i].get("ID")
            if "" == str4ExpVersion.strip():
                flag = False
                PY_LOGGER.info("Sequence[44] inspect expSES version, getting version of expSES failed")
                if "zh" == lang:
                    errMsg += u"\n级联（" + str4ExpId + u"）模块SES版本查询失败"
                else:
                    errMsg += "\nExpansion(" + str4ExpId + ") Module gets the version of SES failed"
            else:
                versionEncTrace.append(str4ExpVersion)
        
        sesEncVersionSort = sorted(versionEncTrace)
        #判断级联框SES版本是否一致
        if 0 != len(sesEncVersionSort):
            if (sesEncVersionSort[0]!=sesEncVersionSort[-1]):
                flag = False
                versionEncDisplay = ""
                for version in versionEncTrace:
                    if "zh" == lang:
                        versionEncDisplay +=version+u"，"
                    else:
                        versionEncDisplay +=version+u","
                versionEncDisplay = versionEncDisplay[:-1]
                if "zh" == lang:
                    errMsg += u"\n级联框SES版本不一致：" + versionEncDisplay
                else:
                    errMsg += "\nThe SES version of expansion module is different: " + versionEncDisplay
        #modified 20140516 end
        return (flag, cliRet, errMsg)
            
    except Exception, exception:
        PY_LOGGER.error("Sequence[44] catch except of check SES version.")
        PY_LOGGER.error("Sequence[44] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[44] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[44] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
