# -*- coding: UTF-8 -*-
import traceback
import re
import common
       
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        cliRet = ""
        errMsg = ""
        lang = py_java_env.get("lang")
        i = 0
        inDeveloper = False
        
        #老版本要切换到developer下面执行
        if "V100R001C00B033" == common.getCurrentVesion(cli):
            retInfo= common.change2Developer(cli, py_java_env)
            cliRet = retInfo[1]
            errMsg = retInfo[2]
            if not retInfo[0]:
                common.anyModel2Cli(cli)
                PY_LOGGER.info("Sequence[5] inspect not pass. (can't enter to developer model!)")
                return(False, cliRet, errMsg)  
            inDeveloper = True
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show bbu life"
        PY_LOGGER.info("Sequence[5] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet4Bbu = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[5] inspect not pass. (system abnormal!)")
            if inDeveloper == True:
                common.anyModel2Cli(cli)
                inDeveloper = False
            return (False, cliRet4Bbu, errMsg)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        #BBU不在位检查通过 modified 20140522 Begin
        if not (re.search("ID", cliRet4Bbu, re.IGNORECASE) and \
                re.search("Remaining Lifetime", cliRet4Bbu, re.IGNORECASE)):
            cliRet4BbuList = cliRet4Bbu.splitlines()
            #BBU不在位
            if re.search("Command executed successfully", cliRet4Bbu, re.IGNORECASE) or len(cliRet4BbuList) <= 3:
                flag = False
                PY_LOGGER.info("Sequence[5] BBU does not exist!")
                if "zh" == lang:
                    errMsg = u"\nBBU不在位。"
                else:
                    errMsg = "\nBBU does not exist."
                return (flag, cliRet4Bbu, errMsg)
        else:
            #检测BBU个数是否达标
            retTuple = common.checkBbuNum(cli, lang, errMsg, cliRet4Bbu)
            flag = retTuple[0]
            cliRet4SysInfo = retTuple[1]
            errMsg = retTuple[2]
            
            #检测BBU寿命
            cliRet4BbuList = cliRet4Bbu.splitlines()
            for line in cliRet4BbuList:
                i = i + 1
                if i >= 5:
                    list2 = line.split()
                    if len(list2) != 2:
                        continue
                    
                    bbuId = list2[0]
                    bbuRemainingLifetime = list2[1]
                    if "--" == bbuRemainingLifetime:
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\nBBU[" + bbuId + u"]生命剩余时间未能查到"
                        else:
                            errMsg += "\nThe remain life of BBU[" + bbuId + "] can't be queried"
                        continue
                    
                    if int(bbuRemainingLifetime) < 60:
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\nBBU(" + bbuId + u")生命剩余时间小于60天"
                        else:
                            errMsg += "\nThe remain life of BBU(" + bbuId + ") is less than 60 days"
                    
            if not flag:
                 PY_LOGGER.info("Sequence[5] inspect not pass.")
         
            if inDeveloper == True:
                common.anyModel2Cli(cli)
                inDeveloper = False
            return (flag, cliRet4Bbu + cliRet4SysInfo, errMsg)
        #巡检项检查结果优化 modified End
        #BBU不在位检查通过 modified 20140522 End

    except Exception, exception:
        PY_LOGGER.error("Sequence[5] catch except of check bbu life.")
        PY_LOGGER.error("Sequence[5] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[5] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[5] catch except of trace back:" + str(traceback.print_exc()))
        if inDeveloper == True:
            common.anyModel2Cli(cli)
            inDeveloper = False
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
