# -*- coding: UTF-8 -*-
import traceback
import common

#增加风扇个数检查  modified 20140522 begin
################################################################
# 函数名称：getEnclosureList
# 功能说明：获取框（或者PCIE交换机）列表
# 传入参数：查看框（或者PCIE交换机）的cli回文cliRet4Enclosure，语言lang
# 返  回  值：框（或者PCIE交换机）列表，通过标识flag，错误信息errMsg
################################################################
def getEnclosureList(cliRet4Enclosure, lang):
    flag = True
    errMsg = ""
    enclosureList = []
    #能够查询到框（或者PCIE交换机）信息
    if re.search("ID", cliRet4Enclosure, re.IGNORECASE) and re.search("Health", cliRet4Enclosure, re.IGNORECASE):
        cliRet4EnclosureList = cliRet4Enclosure.splitlines()
        isSwitchOn = False
        for line in cliRet4EnclosureList:
            #找到"---"后打开开关，并在下一行开始
            if re.search("---", line, re.IGNORECASE):
                isSwitchOn = True
                continue
            #找到":/>"则退出
            if re.search(":/>", line, re.IGNORECASE):
                break
            #如果是空行，则继续
            if "" == line.strip():
                continue
            #开关打开，表示有效行（即在"---"和":/>"之间的非空白行）
            if isSwitchOn:
                enclosureList.append(line.strip().split()[0])
        return (enclosureList, flag, errMsg)
    else:
        #可能产生的其它错误信息
        flag = False
        PY_LOGGER.info("There is an error in Sequence[6]!")
        if "zh" == lang:
            errMsg = u"\n获取信息出错。"
        else:
            errMsg = "\nThere is an error in getting information."
        return (enclosureList, flag, errMsg)

########################################################################
# 函数名称：checkFanNumAndStatus
# 功能说明：检查风扇个数和状态是否达标
# 传入参数：风扇cli回文cliRet4Fan，框（或者PCIE交换机）列表enclosureList，语言lang
# 返 回  值：通过标识flag，错误信息errMsg
########################################################################
def checkFanNumAndStatus(cliRet4Fan, enclosureList, lang):
    flag = True
    errMsg = ""
    enclosureId = ""
    count = 0
    enclosureIdDict = {}
    
    #初始化框（或者PCIE交换机）ID字典
    for enclosure in enclosureList:
        enclosureIdDict[enclosure] = 0
    
    #能够查询到数据
    if re.search("ID", cliRet4Fan, re.IGNORECASE) and re.search("Health", cliRet4Fan, re.IGNORECASE):
        cliRet4FanList = cliRet4Fan.splitlines()
        isSwitchOn = False
        for line in cliRet4FanList:
            #找到"---"后打开开关，并在下一行开始计为数据有效行
            if re.search("---", line, re.IGNORECASE):
                isSwitchOn = True
                continue
            #找到":/>"则先对最后一个计数，然后退出
            if re.search(":/>", line, re.IGNORECASE):
                break
            #如果是空行，则继续
            if "" == line.strip():
                continue
            #开关打开，表示有效行（即在"---"和":/>"之间的非空白行）
            if isSwitchOn:
                #统计风扇个数
                tempId = line.strip().split(".")[0]
                if enclosureIdDict.has_key(tempId):
                    enclosureIdDict[tempId] += 1
                    
                #判断健康和运行状态是否正常
                if not (re.search("Normal", line, re.IGNORECASE) and re.search("Running", line, re.IGNORECASE)):
                    fanID = line.split()[0]
                    flag = False
                    if "zh" == lang:  
                        errMsg += u"\n风扇[" + fanID + u"]状态检查异常"
                    else:
                        errMsg += "\nThe status of fan [" + fanID + "] is abnormal"
                    PY_LOGGER.info("\nSequence[6] inspect not pass.")
        
        #判断风扇个数是否达标：每个框（或PCIE）的风扇个数大于等于2为达标
        PY_LOGGER.info("enclosureIdDict = " + str(enclosureIdDict))
        PY_LOGGER.info("")
        for enclosure in enclosureIdDict.keys():
            if int(enclosureIdDict[enclosure]) < 2:
                flag = False
                PY_LOGGER.info("Sequence[6] the number of fan is not enough")
                if "zh" == lang:
                    errMsg += u"\n框[" + enclosure + u"]的风扇个数不足"
                else:
                    errMsg += "\nThe number of fan in enclosure [" + enclosure + "] is not enough"
        return (flag, errMsg)
    
    #回文结果异常分支
    else:
        cliRet4FanList = cliRet4Fan.splitlines()
        for line in cliRet4FanList:
            #系统没有运行在admin模式
            if line.startswith("-bash") or line.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[6] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", line, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[6]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, errMsg)
            #风扇不在位
            if line.startswith("Command executed successfully."):
                flag = False
                PY_LOGGER.info("Sequence[6] fan is not on the place!")
                if "zh" == lang:
                    errMsg = u"\n风扇不在位。"
                else:
                    errMsg = "\nfan does not exist."
                return (flag, errMsg)
        #可能产生的其它错误信息
        flag = False
        PY_LOGGER.info("There is an error in Sequence[6]!")
        if "zh" == lang:
            errMsg = u"\n获取信息出错。"
        else:
            errMsg = "\nThere is an error in getting information."
        return (flag, errMsg)


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        cliRet = ""
        errMsg = ""
        lang = py_java_env.get("lang")
        
        
        #获取框（或者PCIE交换机）回文
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        cmd4enclosure = "show enclosure"
        checkRet =  common.isCliExecRetInBlackList(cli,cmd4enclosure,lang,True)
        cliRet4Enclosure = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[6] inspect not pass. (system abnormal!)")
            return (False, cliRet4Enclosure, errMsg)
        
        #增加框不在位判断
        cliRet4EnclosureList = cliRet4Enclosure.splitlines()
        if common.isExecSuccess(cliRet4Enclosure) or len(cliRet4EnclosureList) <= 3:
            flag = False
            if "zh" == lang:
                errMsg += u"\n框不在位"
            else:
                errMsg += "\nThere is no enclosure"
            return (flag, cliRet4Enclosure, errMsg)
        
        #获取框ID信息
        enclosureInfoTuple = getEnclosureList(cliRet4Enclosure, lang)
        enclosureList = enclosureInfoTuple[0]
        flag4Enclosure = enclosureInfoTuple[1]
        errMsg4Enclosure = enclosureInfoTuple[2]
        #无法查询到框（或者PCIE交换机）信息，则直接返回
        if 0 == len(enclosureList):
            return (flag4Enclosure, cliRet4Enclosure, errMsg4Enclosure)
        
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #获取风扇状态回文
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        cmd4fan = "show fan"
        checkRet =  common.isCliExecRetInBlackList(cli,cmd4fan,lang,True)
        cliRet4Fan = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[6] inspect not pass. (system abnormal!)")
            return (False, cliRet4Enclosure + cliRet4Fan, errMsg)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        #增加风扇不在位判断
        cliRet4FanList = cliRet4Fan.splitlines()
        if common.isExecSuccess(cliRet4Fan) or len(cliRet4FanList) <= 3:
            flag = False
            if "zh" == lang:
                errMsg += u"\n风扇不在位"
            else:
                errMsg += "\nThere is no fan"
            return (flag, cliRet4Enclosure + cliRet4Fan, errMsg)
        
        
        #检查风扇个数和状态是否达标
        fanNumAndStatusCheckRetTuple = checkFanNumAndStatus(cliRet4Fan, enclosureList, lang)
        flag4FanNumAndStatusCheck = fanNumAndStatusCheckRetTuple[0]
        errMsg4FanNumAndStatusCheck = fanNumAndStatusCheckRetTuple[1]
        
        #返回结果
        flag = flag4Enclosure and flag4FanNumAndStatusCheck
        cliRet = cliRet4Enclosure + cliRet4Fan
        errMsg = errMsg4Enclosure + errMsg4FanNumAndStatusCheck
        return (flag, cliRet, errMsg)
        
        #增加风扇个数检查  modified 20140522 End
    except Exception, exception:
        PY_LOGGER.error("Sequence[6] catch except of check fan status.")
        PY_LOGGER.error("Sequence[6] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[6] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[6] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)

