# -*- coding: UTF-8 -*-
import traceback
import re
import util

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check POOL status
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    flag = True
    cliRet = ""
    errMsg = ""
    lang = ""
    try:
        lang = py_java_env.get("lang")
        cliRet = cli.execCmd("show storage_pool general")
        
        #中文回显 modify 20140623 begin
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = True
            return (flag, cliRet, errMsg)
        
        formatedDictList = util.formatStr(cliRet)
        for i in range(len(formatedDictList)):
            id = str(formatedDictList[i].get("ID"))
            healthStatus = str(formatedDictList[i].get("Health Status"))
            runningStatus = str(formatedDictList[i].get("Running Status"))
            #modified 20140327 begin
            if ("normal" != healthStatus.lower() or "online" != runningStatus.lower()):
                PY_LOGGER.info("Sequence[62] inspect pool, health status:" + healthStatus + ", running status:" + runningStatus)
                flag = False
                if "zh" == lang:
                    errMsg += u"\nPool[" + id + u"]状态异常。"
                else:
                    errMsg += "\nThe status of pool[" + id + "] is abnormal."
            #modified 20140327 end
        #中文回显 modify 20140623 end
        
        return(flag, cliRet, errMsg)
    except:
        PY_LOGGER.error("Sequence[62] catch except of trace back:" + traceback.format_exc())
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
