# -*- coding: UTF-8 -*-
import traceback
import re
import util

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check hotspare spaces
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    flag = True
    cliRet = ""
    errMsg = ""
    lang = ""
    try:
        lang = py_java_env.get("lang")
        cliRet = cli.execCmd("show disk_domain general")
        
        #中文回显 modify 20140623 begin
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = True
            return (flag, cliRet, errMsg)
        
        formatedDictList = util.formatStr(cliRet)
        for i in range(len(formatedDictList)):
            id = str(formatedDictList[i].get("ID"))
            usedHotSpareCap = str(formatedDictList[i].get("Used Hot Spare Capacity"))
            if usedHotSpareCap != "0.000B":
                PY_LOGGER.info("Sequence[64] inspect Used Hot Spare Capacity:" + usedHotSpareCap)
                flag = False
                
                if usedHotSpareCap.strip() in ["--", ""]:
                    if "zh" == lang:
                        errMsg += u"\nDomain[" + id + u"]的Hotspare Used Capacity信息未找到。"
                    else:
                        errMsg += "\nFailed to find The Hotspare Used Capacity in Domain[" + id + "]."
                    continue
                
                if "zh" == lang:
                    errMsg += u"\nDomain[" + id + u"]的Hotspare Used Capacity大于0。"
                else:
                    errMsg += "\nThe Hotspare Used Capacity in domain[" + id + "] is more than 0."
                
        #中文回显 modify 20140623 end
        
        return (flag, cliRet, errMsg)
    except:
        PY_LOGGER.error("Sequence[64] catch except of trace back:" + traceback.format_exc())
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
