# -*- coding: UTF-8 -*-
import traceback
import common
            
def execute(cli):
    """
    Create date        : 2012/05/25
    Function name      : execute(cliConnection)
    Function describe  : check BST switch
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = False
        lang = py_java_env.get("lang")
        cliRet = ""
        errMsg = ""
       
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show bst enabled"
        PY_LOGGER.info("Sequence[67] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[67] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
    	list = cliRet.splitlines()
    	i = 0
    	for field in list:            
            i = i+1
            if i > 2:
                field = field.replace(" ", "")
                if field.startswith("Enabled:"):
                    if (field.replace("Enabled:", "") == "Yes") or (field.replace("Enabled:", "") == "No"):
                        flag = True
                        return(flag, cliRet)
        
        PY_LOGGER.info("Sequence[67] inspect not pass.")
    	if "zh" == lang:
            errMsg = u"\n硬盘BST状态检查异常"
        else:
            errMsg = "\nThe BST status of hard disk is abnormal"
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[67] catch except of check BST switch.")
        PY_LOGGER.error("Sequence[67] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[67] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[67] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
