import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18, Midify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : check LUN write policy
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet0 =""
        cliRet1 =""
        cliRet2 =""
        cliRet3=""
        cliRetall=""
        checkRet2 =""
        filterCmd0 = "show lun general |filterRow column=Write\sPolicy predict=not predict2=equal_to value=Write\sBack logicOp=and column=Write\sPolicy predict=not predict2=equal_to value=Write\sThrough logicOp=and column=Write\sPolicy predict=not predict2=equal_to value=Write\sBack\sMandatory"
        filterCmd1 = "show lun general |filterRow column=Write\sPolicy predict=equal_to value=Write\sBack logicOp=and column=Running\sWrite\sPolicy predict=not predict2=equal_to value=Write\sBack"
        filterCmd2 = "show lun general |filterRow column=Write\sPolicy predict=equal_to value=Write\sThrough logicOp=and column=Running\sWrite\sPolicy predict=not predict2=equal_to value=Write\sThrough"
        filterCmd3 = "show lun general |filterRow column=Write\sPolicy predict=equal_to value=Write\sBack\sMandatory logicOp=and column=Running\sWrite\sPolicy predict=not predict2=equal_to value=Write\sBack\sMandatory"
        
        PY_LOGGER.info("\nSequence[68] begin to inspect, exec cli command:"+str(filterCmd1))
       
       
        checkRet0 =  common.isCliExecRetInBlackList(cli,filterCmd0,lang,True)
        cliRet0 = checkRet0[1]
        cliRetall+= cliRet0
        errMsg += checkRet0[2]
        if checkRet0[0]:
            PY_LOGGER.info("Sequence[68] inspect not pass. (system abnormal!)")
            return (False, cliRetall, errMsg)
        
        #命令执行成功不用判断
        if not common.isExecSuccess(cliRet0):
            list = cliRet0.splitlines()
            i = 0
            #巡检项检查结果优化 modified Begin
            lunID = ""
            for field in list:
                i = i + 1
                
                if i > 3:
                    flag = False
                    if field.find("---") != -1 or field.find("ID") != -1:
                        continue
                    list2 = field.split()
                    if len(list2) < 3:
                        continue
                    lunID = list2[0]
                    
                    if "zh" == lang:
                        errMsg += u"\nLun[" + lunID + u"]的写策略没有正确数据"
                    else:
                        errMsg += "\nThe write policy of lun [" + lunID + "] is invalid"
                    
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,filterCmd1,lang,True)
        cliRet1 = checkRet[1]
        cliRetall +=cliRet1
        errMsg += checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[68] inspect not pass. (system abnormal!)")
            return (False, cliRetall, errMsg)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        
        #命令执行成功不用判断
        if not common.isExecSuccess(cliRet1):
            list = cliRet1.splitlines()
            i = 0
            #巡检项检查结果优化 modified Begin
            lunID = ""
            for field in list:
                i = i + 1
                
                if i > 3:
                    flag = False
                    if field.find("---") != -1:
                        continue
                    list2 = field.split()
                    if len(list2) < 3:
                        continue
                    lunID = list2[0]
                    
                    if "zh" == lang:
                        errMsg += u"\nLun[" + lunID + u"]的写策略与运行写策略不一致"
                    else:
                        errMsg += "\nThe write policy of lun [" + lunID + "] is not consistent with running write policy"

        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet2 =  common.isCliExecRetInBlackList(cli,filterCmd2,lang,True)
        cliRet2 = checkRet2[1]
        cliRetall +=cliRet2
        errMsg += checkRet2[2]
        if checkRet2[0]:
            PY_LOGGER.info("Sequence[68] inspect not pass. (system abnormal!)")
            return (False, cliRetall, errMsg)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        #命令执行成功不用判断
        if not common.isExecSuccess(cliRet2):
            list = cliRet2.splitlines()
            i = 0
            for field in list:
                i = i + 1
                if i > 3:
                    flag = False
                    if field.find("---") != -1:
                        continue
                    list2 = field.split()
                    if len(list2) < 3:
                        continue
                    lunID = list2[0]
                    
                    if "zh" == lang:
                        errMsg += u"\nLun [" + lunID + u"] 的写策略与运行写策略不一致"
                    else:
                        errMsg += "\nThe write policy of lun [" + lunID + "] is not consistent with running write policy"
                        
        checkRet3 =  common.isCliExecRetInBlackList(cli,filterCmd3,lang,True)
        cliRet3 = checkRet3[1]
        cliRetall +=cliRet3
        errMsg += checkRet3[2]
        if checkRet3[0]:
            PY_LOGGER.info("Sequence[68] inspect not pass. (system abnormal!)")
            return (False, cliRetall, errMsg)
        
        #命令执行成功不用判断
        if not common.isExecSuccess(cliRet3):
            list = cliRet3.splitlines()
            i = 0
            for field in list:
                i = i + 1
                if i > 3:
                    flag = False
                    if field.find("---") != -1:
                        continue
                    list2 = field.split()
                    if len(list2) < 3:
                        continue
                    lunID = list2[0]
                    
                    if "zh" == lang:
                        errMsg += u"\nLun [" + lunID + u"] 的写策略与运行写策略不一致"
                    else:
                        errMsg += "\nThe write policy of lun [" + lunID + "] is not consistent with running write policy"

        if not flag:
             PY_LOGGER.info("Sequence[68] inspect not pass.")
             
        return (flag, cliRetall, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[68] catch except of check LUN write policy.")
        PY_LOGGER.error("Sequence[68] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[68] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[68] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet1+cliRet2, errMsg)
