# -*- coding: UTF-8 -*-
import traceback
import common
    
G_RETRY_TIMES = 30
def execute(cli):
    """
    Create date        : 2012/05/18,Modify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : execute warning alarm check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        send_alarm = True
        alarmID = [
         "0xF00150019",
         "0xF0015001A",
         "0xF0015001B",
         "0x100F0015001C",
         "0xF0015001D"]
    	errMsg = "" 
        if "zh" == lang:
            errMsg =u"产生的告警ID为： " 
        else:
            errMsg = "The ID of the alarm is: "
    	errMsgtmp = ""
        cliRetall = ""

        for element in alarmID:
            cliRet = ""
            send_alarm = True
            cmd = "show alarm |filterRow column=ID predict=equal_to " + "value=" + element
            PY_LOGGER.info("Sequence[70] begin to inspect, exec cli command:" + str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.cliExecRetWithTimeout(cli, cmd, G_RETRY_TIMES, lang)
            cliRet = checkRet[1]
            errMsgtmp =errMsgtmp +u"\n告警ID["+element+u"]"+checkRet[2]
            cliRetall += cliRet
            if common.CLI_RET_FAULT == checkRet[0]:
                PY_LOGGER.info("Sequence[70] inspect not pass. (system abnormal!)")
                return (False, cliRetall, errMsgtmp)
				
            PY_LOGGER.info("\nSequence[70] execute command result:\n" + cliRet)
            list = cliRet.splitlines()
            for field in list:
                PY_LOGGER.info("\nFiled=" + field)
                if field.find("Command executed successfully") != -1:
                    send_alarm = False
                else:
                    continue
                
            if send_alarm == True:
                flag = False
                errMsg += "\n"+element 
        
        if not flag:
             PY_LOGGER.info("Sequence[70] inspect not pass.")
        return (flag, cliRetall, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[70] catch except of check warning alarm.")
        PY_LOGGER.error("Sequence[70] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[70] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[70] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
