# -*- coding: UTF-8 -*-
import traceback
import re
import util

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check snapshot general status
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    flag = True
    cliRet = ""
    errMsg = ""
    lang = ""
    try:
        lang = py_java_env.get("lang")
        cliRet = cli.execCmd("show snapshot general")
        
        #中文回显 modify 20140623 begin
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = True
            return (flag, cliRet, errMsg)
        
        formatedDictList = util.formatStr(cliRet)
        for i in range(len(formatedDictList)):
            id = str(formatedDictList[i].get("ID"))
            healthStatus = str(formatedDictList[i].get("Health Status"))
            if "normal" != healthStatus.lower():
                PY_LOGGER.info("Sequence[83] inspect snapshot general, healthStatus:" + healthStatus + ", ID: " + id)
                flag = False
                if "zh" == lang:
                    errMsg += u"\n快照[" + id + u"]状态异常[" + healthStatus + u"]。"
                else:
                    errMsg += "\nThe status of snapshot[" + id + "] is abnormal[" + healthStatus + "]."
        #中文回显 modify 20140623 end
        
        return (flag, cliRet, errMsg)
    except:
        PY_LOGGER.error("Sequence[83] catch except of trace back:" + traceback.format_exc())
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
