# -*- coding: UTF-8 -*-
import traceback
import re
import util

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check lun_copy general status
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    flag = True
    cliRet = ""
    errMsg = ""
    lang = ""
    try:
        lang = py_java_env.get("lang")
        cliRet = cli.execCmd("show lun_copy general")

        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #中文回显 modify 20140623 begin
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = True
            return (flag, cliRet, errMsg)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        formatedDictList = util.formatStr(cliRet)
        #巡检项检查结果优化 modified Begin
        for i in range(len(formatedDictList)):
            id = str(formatedDictList[i].get("ID"))
            healthStatus = str(formatedDictList[i].get("Health Status"))
            if "normal" != healthStatus.lower():
                PY_LOGGER.info("Sequence[84] inspect Lun_copy general, healthStatus:" + healthStatus + ", ID:" + id)
                flag = False
                if "zh" == lang:
                    errMsg += u"\nLUN拷贝[" + id + u"]状态检测异常。"
                else:
                    errMsg += "\nThe status of LUN copy[" + id + "] is abnormal."
        #中文回显 modify 20140623 end
        
        return (flag, cliRet, errMsg)
        #巡检项检查结果优化 modified End
    
    except:
        PY_LOGGER.error("Sequence[84] catch except of trace back:" + traceback.format_exc())
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
