# -*- coding: UTF-8 -*-
import traceback
import re
import util

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check clone general status
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    flag = True
    cliRet = ""
    errMsg = ""
    lang = ""
    try:
        lang = py_java_env.get("lang")
        cliRet = cli.execCmd("show clone general")
        
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #中文回显  modify 20140623 begin
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = True
            return (flag, cliRet, errMsg)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        formatedDictList = util.formatStr(cliRet)
        for i in range(len(formatedDictList)):
            id = str(formatedDictList[i].get("Clone ID"))
            healthStatus = str(formatedDictList[i].get("Health Status"))
            if "normal" != healthStatus.lower():
                PY_LOGGER.info("Sequence[85] inspect clone general, healthStatus:" + healthStatus + ", ID:" + id)
                flag = False
                if "zh" == lang:
                    errMsg += u"\n克隆[" + id + u"]状态检测异常。"
                else:
                    errMsg += "\nThe status of clone["+ id +"] is abnormal."
        #中文回显  modify 20140623 end
        
        return (flag, cliRet, errMsg)
    except:
        PY_LOGGER.error("Sequence[85] catch except of trace back:" + traceback.format_exc())
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)