# -*- coding: UTF-8 -*-
import traceback
import common
G_ITEM_NUM_CONTROLLER = 2
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = ""
        cmd = "show license"
        checkRet =  common.cliExecRetJudgeWithDoubleList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if common.CLI_RET_FAULT == checkRet[0]:
            #没有license时判定为通过
            if -1 != checkRet[1].find("The license file verification failed.") \
            or -1 != checkRet[1].find("The License file does not exist"):
                return (True, cliRet, "")
            PY_LOGGER.info("Sequence[87] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)        
        #命令执行后包含Command executed successfully等标志，直接退出，巡检通过
        elif common.CLI_RET_SUCCESS == checkRet[0]:
            return (True, cliRet, "")
        
        cliRetLines = cliRet.splitlines()
        for line in cliRetLines:
            line = line.strip()
            if not line.startswith("Left Day(s)"):
                continue
            
            leftDaysList = line.split(":")
            if len(leftDaysList) != 2:
                errInfoDict = {
                               "zh":u"\n无法获取license信息",
                               "en":"\nCannot get information about license"
                               }
                errMsg = errInfoDict.get(lang)
                return ("NOCHECK", cliRet, errMsg)  # 修改备注：解析回显失败导致列表长度为0
            
            leftDays = leftDaysList[1].strip()
            if int(leftDays) < 1825:
                errInfoDict = {
                               "zh":u"\n存在临时license",
                               "en":"\nA temporary license exists",
                               }
                errMsg = errInfoDict.get(lang)
                return (False, cliRet, errMsg)
            
        return (True, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[87] catch except of check controller status.")
        PY_LOGGER.error("Sequence[87] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[87] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[87] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
            
        return (flag, cliRet, errMsg)
