# -*- coding: UTF-8 -*-
import traceback
import common
HAS_RECORD_MIN_LINES = 3

def execute(cli):
    """
    Create date        : 2012/05/18,Modify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : execute warning alarm check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""

      
            
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show alarm level=warning number=10"
        PY_LOGGER.info("Sequence[93] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[93] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        
        #命令执行后包含Command executed successfully，直接退出，巡检通过
        if common.isExecSuccess(cliRet):
            return (True, cliRet)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        list = cliRet.splitlines()
        n=len(list)
        PY_LOGGER.info("Sequence[93] len is="+str(n))
        if len(list)>HAS_RECORD_MIN_LINES:
            flag = False
            PY_LOGGER.info("Sequence[93] inspect not pass.")
            if "zh" == lang:
                errMsg = u"\n系统存在警告告警"
            else:
                errMsg = "\nSystem exists warning alarm"
            return (flag, cliRet, errMsg)
        return (flag, cliRet)

    except Exception, exception:
        PY_LOGGER.error("Sequence[93] catch except of check warning alarm.")
        PY_LOGGER.error("Sequence[93] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[93] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[93] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
