# -*- coding: UTF-8 -*-
import re 
import util


def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""

    cliRet = cli.execCmd("show interface_module")
    list = cliRet.splitlines()
    if len(list) < 5:
       if not util.checkCliInfoValid(cliRet, False):
           flag = False
           if lang == "zh":
               errMsg = u"无效CLI信息"
           else:
               errMsg = "Invalid Cli information."
       else:
            flag = True       
       return (flag, cliRet, errMsg)  
    
    StatusList = util.formatStr(cliRet)
    for i in range(len(StatusList)):  
        InterfaceID = StatusList[i].get("ID")     
        HealthStatus = StatusList[i].get("Health Status")
        RunningStatus = StatusList[i].get("Running Status")    
        if "normal" != HealthStatus.lower() or "running" != RunningStatus.lower():
            flag = False
            if "zh" == lang:
                errMsg += u"\n接口卡（" + InterfaceID + u"）状态异常（健康状态" + HealthStatus + u"，运行状态" + RunningStatus + u"）。"
            else:
                errMsg += "\nThe interface module(" + InterfaceID +") runs abnormally(health status: " + HealthStatus + ", running status: " + RunningStatus + ")."
    return (flag, cliRet, errMsg)