# -*- coding: UTF-8 -*-
import re 
import util


def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""

    cliRet = cli.execCmd("show system general")
    list = cliRet.splitlines()
    if len(list) < 5:
       if not util.checkCliInfoValid(cliRet, True):
           flag = False
           if lang == "zh":
               errMsg = u"无效CLI信息"
           else:
               errMsg = "Invalid Cli information."
       else:
            flag = True       
       return (flag, cliRet, errMsg)  
    
    SystemDict = util.formatStr(cliRet)    
    HealthStatus = SystemDict.get("Health Status")
    RunningStatus = SystemDict.get("Running Status")    
    if "Normal" not in HealthStatus or "Normal" not in RunningStatus:
        flag = False
        if "zh" == lang:
            errMsg += u"\n系统状态异常（健康状态" + HealthStatus + u"，运行状态" + RunningStatus + u"）。"
        else:
            errMsg += "\nThe system runs abnormally(health status: " + HealthStatus + ", running status: " + RunningStatus + ")."
    return (flag, cliRet, errMsg)