# -*- coding: UTF-8 -*-
import common


LANG = common.getLang(py_java_env)

def execute(cli):
    '''
    @summary: 检查当前设备型号和版本号，且是否包含4K盘
    '''
    
    cliRet = ""
    errMsg = ""
    flag = True
    checkRet = True
    all4KDiskList = []
    
    #定义问题型号和版本号
    bugProduct_18000 = ("HVS85T", "HVS88T", "18500", "18800", "18800F")
    bugVersionWith_18000 = "V100R001C00"
    
    #查询产品型号
    result, cliRet, productModel = common.getProductModel(cli, LANG)
    if not result:
        if "zh" == LANG:
            errMsg = u"\n获取产品型号失败。"
        else:
            errMsg = "\nFailed to query the product model."
        return (False, cliRet, errMsg)
    
    if productModel not in bugProduct_18000:
        return (cliUtil.RESULT_NOSUPPORT, cliRet, "")
    
    #获取版本号和补丁版本号，并判断是否为风险版本
    resultList, currentVersionDictList, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
    cliRet += resultList[1]
    if resultList[0] != True:
        return (resultList[0], cliRet, resultList[2])
    
    result, currentVersion, errInfo = common.getCurrentVersion(currentVersionDictList, LANG)
    if not result:
        errMsg += errInfo
        return (False, cliRet, errMsg)
     
    #检查产品版本是否有风险
    if not currentVersion.startswith(bugVersionWith_18000):
         return (True, cliRet, errMsg)
    
    #检查是否有大于1TB的SAS盘，或大于5TB的NL SAS盘
    result, cmdRet, errInfo, is4kDiskListCap = common.get4kDiskInfo(cli, LANG)
    cliRet += cmdRet
    errMsg += errInfo
    if is4kDiskListCap or not result:
        checkRet = False
     
    return (checkRet, cliRet, errMsg)
    
    