﻿# -*- coding: UTF-8 -*-
import traceback
import common
import util

def execute(cli):
    """
    硬盘的固件版本检查
    1 如果硬盘的检查标准满足以下条件之一，则检查结果为建议优化；否则检查结果为通过。
      1） Model为HUS156060VLS600，且Firmware Version为A510,A760其中之一；
      2） Model为HUS156060VLF400，且Firmware Version为fT02,F510其中之一；
    """
    
    flag = True
    bugDiskIDList = []
    lang = py_java_env.get("lang")
    errMsg = ""
    cliRet = ""
    #存在问题的固件Model与对应的FW
    bugFWVersionMap = {
                        "HUS156060VLS600":("A510","A760"),
                        "HUS156060VLF400":("FT02","F510"),
                        }

    #存放无法获取固件版本值的硬盘
    errInfoDiskIDList = []  
    try:
        cmd = "show disk general|filterColumn include columnList=ID,Model,Firmware\\sVersion"
        #CLI命令执行后，通过接口初步判断命令是否命令不支持
        checkRet = common.isCliExecRetInBlackList(cli, cmd, lang, False)
        flagRet =  common.hasCliExecPrivilege(checkRet[1])
        if not flagRet:
            cmd = "show disk general|filterColumn include colunmList=ID,Model,Firmware\\sVersion"
            checkRet = common.isCliExecRetInBlackList(cli, cmd, lang, False)
        cliRet = checkRet[1]
        if checkRet[0]:
            errMsg = checkRet[2]
            return (False, cliRet, errMsg)

        #命令执行后包含Command executed successfully，直接退出，巡检通过
        if common.isExecSuccess(cliRet):
            return (True, cliRet, errMsg)

        diskDictList = common.getHorizontalCliRet(cliRet)
        for diskDict in diskDictList:
            diskID = diskDict.get("ID","")
            model = diskDict.get("Model","")
            FWVersion = diskDict.get("Firmware Version","")
            bugVersionList = bugFWVersionMap.get(model)
            if FWVersion == "" or FWVersion == "--":
                errInfoDiskIDList.append(diskID)
                continue
            if not bugVersionList:
                continue
            if FWVersion.upper() in bugVersionList:
                bugDiskIDList.append(diskID)

        PY_LOGGER.info("bugDiskIDList:" + str(bugDiskIDList))
        if bugDiskIDList:
            flag = util.RESULT_WARNING
            message = {"zh":u"\n固件版本较低的硬盘如下：\n%s",
                       "en":"\nDisks whose firmware versions are too early are as follows: \n%s",
                      }
            errMsg = message.get(lang) % ", ".join(bugDiskIDList)
        if errInfoDiskIDList:
            flag = False
            message = {"zh":u"\n无法获取固件版本的硬盘如下：\n%s",
                       "en":"\nDisks whose firmware version cannot be obtained are as follows: \n%s",
                      }
            errMsg += message.get(lang) % ", ".join(errInfoDiskIDList)

        return (flag, cliRet, errMsg)

    except Exception:
        PY_LOGGER.error("Sequence[check disk Firmware Version] catch except of trace back:" + str(traceback.format_exc()))
        flag = False
        message = {"zh":u"\n查询结果异常",
                   "en":"\nQuery result is abnormal",
                  }
        errMsg = message.get(lang)
        return (flag, cliRet, errMsg)
