# -*- coding: UTF-8 -*-
import util
import traceback

LANG = py_java_env.get("lang")

def execute(cli):
    '''
        硬盘域热备策略检查: 
        1 如果硬盘域不存在表示正常；
        2 Health Status为Normal且Running Status为Online表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    warningFlag = False
    cliRet = ""
    errMsg = ""
    cofferDiskIdList = []
    allCliRet = ""

    try:
        cmd = "show disk general|filterRow column=Coffer\sDisk predict=equal_to value=Yes"
        cliRet = cli.execCmd(cmd)
        allCliRet += cliRet
        cmdRetList = cliRet.splitlines()
        #判断回显信息有效性
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = util.RESULT_NOCHECK
                if LANG == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = True
            return (flag, cliRet, errMsg)
        
        formatedDictList = util.formatStr(cliRet)
        for i in range(len(formatedDictList)):
            cofferDiskIdList.append(str(formatedDictList[i].get("ID")))   
        
        cmd = "show disk_domain general"
        cliRet = cli.execCmd(cmd)
        cmdRetList = cliRet.splitlines()
        allCliRet += cliRet
        #判断回显信息有效性
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = util.RESULT_NOCHECK
                if LANG == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = True
            return (flag, allCliRet, errMsg)
        
        formatedDictList = util.formatStr(cliRet)
        for i in range(len(formatedDictList)):
            id = str(formatedDictList[i].get("ID"))
            cmd = "show disk in_domain disk_domain_id=" + id
            cliRet = cli.execCmd(cmd)
            allCliRet += cliRet
            cmdRetList = cliRet.splitlines()
            
            #判断回显信息有效性
            if len(cmdRetList) < 5:
                if not util.checkCliInfoValid(cliRet, False):
                    flag = util.RESULT_NOCHECK
                    if LANG == "zh":
                        errMsg = u"无效CLI信息。"
                    else:
                        errMsg = "Invalid Cli information."
                else:
                    flag = True
                return (flag, allCliRet, errMsg)
            cliFlag = util.checkDiskInSameEngine(cliRet)
            if cliFlag == False:
                warningFlag = True
                if LANG == "zh":
                    errMsg += u"\n硬盘域[ID:" + id + u"]跨引擎。"
                else:
                    errMsg += "\nDisk Domain[ID:"+ id + "] in different engines."
                PY_LOGGER.info("disk domain disk in different engines check fail")
                
            typeList = util.checkDiskCapacity(cliRet, cofferDiskIdList)
            if typeList[0] or typeList[1]:
                warningFlag = True
                for diskType in typeList[0]:
                    if LANG == "zh":
                        errMsg += u"\n硬盘域[ID:" + id + u"]中硬盘类型为[" + diskType +u"]容量不一致。"
                    else:
                        errMsg += "\nIn disk domain[ID:"+ id + "], the capacities of [" + diskType + "] disks are different."
                
                for diskType in typeList[1]:
                    if LANG == "zh":
                        errMsg += u"\n硬盘域[ID:" + id + u"]中的[" + diskType +u"]硬盘转速不一致。"
                    else:
                        errMsg += "\nIn disk domain[ID:"+ id + "], the rotational speed of [" + diskType + "] disks are different."
                
                PY_LOGGER.info("disk domain disk type check fail")
                
        if warningFlag:
            flag = util.RESULT_WARNING
            
            
        return (flag, allCliRet, errMsg)
        
    except:
        PY_LOGGER.error("Sequence[disk_domain] catch except of trace back:" + traceback.format_exc())
        flag = util.RESULT_NOCHECK
        if "zh" == LANG:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, allCliRet, errMsg)

