# -*- coding: UTF-8 -*-
import util
import common
import traceback

LANG = py_java_env.get("lang")

def execute(cli):
    '''
        硬盘域热备策略检查: 
        1 如果硬盘域不存在表示正常；
        2 Health Status为Normal且Running Status为Online表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    warningFlag = False
    passFlag = False
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show disk_domain general |filterColumn include columnList=ID,Tier0\\sDisk\\sNumber,Tier1\\sDisk\\sNumber,Tier2\\sDisk\\sNumber"
        cliRet = cli.execCmd(cmd)
        if not util.hasCliExecPrivilege(cliRet):
            cmd = "show disk_domain general |filterColumn include colunmList=ID,Tier0\\sDisk\\sNumber,Tier1\\sDisk\\sNumber,Tier2\\sDisk\\sNumber"
            cliRet = cli.execCmd(cmd)
        cmdRetList = cliRet.splitlines()
        #判断回显信息有效性
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if LANG == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = True
            return (flag, cliRet, errMsg)
       
        formatedDictList = util.formatStr(cliRet)
        for i in range(len(formatedDictList)):
            id = str(formatedDictList[i].get("ID")) 
            tier0Num = int(formatedDictList[i].get("Tier0 Disk Number")) 
            tier1Num = int(formatedDictList[i].get("Tier1 Disk Number")) 
            tier2Num = int(formatedDictList[i].get("Tier2 Disk Number"))
            if tier0Num <= 96 and tier1Num <= 96 and tier2Num <= 96: 
                passFlag = True
            else:
                warningFlag = True
                if LANG == "zh":
                    errMsg += u"\n硬盘域[" + id + u"]上tier0的盘数：" + str(tier0Num) +u"，tier1的盘数：" + str(tier1Num) +u"，tier2的盘数：" + str(tier2Num) +u"。"
                else:
                    errMsg += "\nNumber of disks for tier0 of disk domain [ID:"+ id +"]:" + str(tier0Num) + ",number of disks for tier1:" + str(tier1Num) + ",number of disks for tier2:" + str(tier2Num) + "."

                PY_LOGGER.info("diskdomain disknum check fail")
                
        if warningFlag:
            flag = util.RESULT_WARNING
        elif passFlag:
            flag = True
        return (flag, cliRet, errMsg)
        
    except:
        PY_LOGGER.error("Sequence[disk_domain] catch except of trace back:" + traceback.format_exc())
        flag = False
        if "zh" == LANG:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)

