# -*- coding: UTF-8 -*-
import util
import common
import traceback
LANG = py_java_env.get("lang")

def execute(cli):
    '''
        硬盘域热备策略检查: 
        1 如果硬盘域不存在表示正常；
        2 Health Status为Normal且Running Status为Online表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    warningFlag = False
    passFlag = False
    failFlag = False
    cliRet = ""
    errMsg = ""

    try:
        cmd = "show disk_domain general |filterColumn include columnList=ID,Tier0\\sHot\\sSpare\\sStrategy,Tier1\\sHot\\sSpare\\sStrategy,Tier2\\sHot\\sSpare\\sStrategy"
        cliRet = cli.execCmd(cmd)
        if not util.hasCliExecPrivilege(cliRet):
            cmd = "show disk_domain general |filterColumn include colunmList=ID,Tier0\\sHot\\sSpare\\sStrategy,Tier1\\sHot\\sSpare\\sStrategy,Tier2\\sHot\\sSpare\\sStrategy"
            cliRet = cli.execCmd(cmd)
        cmdRetList = cliRet.splitlines()
        #判断回显信息有效性
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if LANG == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = True
            return (flag, cliRet, errMsg)
        formatedDictList = util.formatStr(cliRet)
        for i in range(len(formatedDictList)):
            id = str(formatedDictList[i].get("ID")) 
            tier0Strategy = str(formatedDictList[i].get("Tier0 Hot Spare Strategy")) 
            tier1Strategy = str(formatedDictList[i].get("Tier1 Hot Spare Strategy")) 
            tier2Strategy = str(formatedDictList[i].get("Tier2 Hot Spare Strategy"))
            if tier0Strategy in ["--","High"] and tier1Strategy in ["--","High"] and tier2Strategy in ["--","High"]:
                passFlag = True
            if tier0Strategy == "Low" or tier1Strategy == "Low" or tier2Strategy == "Low":
                warningFlag = True
                if LANG == "zh":
                    errMsg += u"\n硬盘域[" + id + u"]上tier0的热备策略：" + tier0Strategy +u"，tier1的热备策略：" + tier1Strategy +u"，tier2的热备策略：" + tier2Strategy +u"。"
                else:
                    errMsg += "\nHot Spare Strategy for tier0 of disk domain [ID:"+ id +"]:" + tier0Strategy + ",Hot Spare Strategy for tier1:" + tier1Strategy + ",Hot Spare Strategy for tier2:" + tier2Strategy + "."
                PY_LOGGER.info("Diskdomain Hot Spare Strategy check warning")
            if tier0Strategy == "None" or tier1Strategy == "None" or tier2Strategy == "None":
                failFlag = True
                if LANG == "zh":
                    errMsg += u"\n硬盘域[" + id + u"]上tier0的热备策略：" + tier0Strategy +u"，tier1的热备策略：" + tier1Strategy +u"，tier2的热备策略：" + tier2Strategy +u"。"
                else:
                    errMsg += "\nHot Spare Strategy for tier0 of disk domain [ID:"+ id +"]:" + tier0Strategy + ",Hot Spare Strategy for tier1:" + tier1Strategy + ",Hot Spare Strategy for tier2:" + tier2Strategy + "."
                PY_LOGGER.info("Diskdomain Hot Spare Strategy check fail")
                
        if failFlag:
            flag = False
        elif warningFlag:
            flag = util.RESULT_WARNING
        return (flag, cliRet, errMsg)
        
    except:
        PY_LOGGER.error("Sequence[disk_domain] catch except of trace back:" + traceback.format_exc())
        flag = False
        if "zh" == LANG:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)

