# -*- coding: UTF-8 -*-
import traceback
import re 
import util
import cliModeManager
import cliCmdManager
from constant import DEVELOPER_CMD
from constant import LUN_METADATA_INSPECT_START_VER
from commonFunction import getUserLevel
from commonFunction import getLunIDList
from commonFunction import getProductFullVersion


def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    cliRet = ""
    errMsg = ""
    javaEnv = py_java_env
    logger = PY_LOGGER
    lang = javaEnv.get("lang")
    
    try:
        getSucc, cliRet1, fullVer = getProductFullVersion(cli, logger)
        cliRet += cliRet1
        if not getSucc:
            if "zh" == lang:
                errMsg = u"\n查询系统版本号失败。"
            else:
                errMsg = u"\nFailed to query the system product version."
            return (False, cliRet, errMsg)    
        
        logger.info('Current system product version:' + str(fullVer))
          
        #(HVS:V1R1C00SPC300; TV2R2: V2R2C00SPC300)开始支持该巡检项。
        if fullVer < LUN_METADATA_INSPECT_START_VER:
            logger.info('Current version does not support this inspect item.')
            if "zh" == lang:
                errMsg = u"\n当前系统版本不支持该巡检项。"
            else:
                errMsg = u"\nCurrent system version does not support this inspection item."
            return ('NOSUPPORT', cliRet, errMsg)
        
        #Query all LUN information.
        getLunIDListSucc, cliRet3, lunIdList= getLunIDList(cli, logger)
        cliRet += cliRet3
        if not getLunIDListSucc:
            if "zh" == lang:
                errMsg = u"\n查询LUN信息失败。"
            else:
                errMsg = "\nFailed to query the LUN information."
            return (False, cliRet, errMsg)
                
        if not lunIdList:
            logger.info('No LUN exists, need not to check.')
            return (True, cliRet, errMsg) 
        
        #guest用户不允许进入developer模式，无法巡检
        userName =  javaEnv.get("devInfoMap").get('userName')
        logger.info('Log in user name:' + str(userName))
        getUsrLvlSucc, cliRet2, userLvl = getUserLevel(userName, cli, logger)
        cliRet += cliRet2
        if not getUsrLvlSucc:
            if "zh" == lang:
                errMsg = u"\n查询用户级别失败。"
            else:
                errMsg = "\nFailed to query the user level."
            return (False, cliRet, errMsg)

        logger.info('User level:' + str(userLvl))
        if userLvl == 'Guest':
            if "zh" == lang:
                errMsg = u"\n只读用户不能执行该巡检项，请使用管理员或者超级管理员重新登录执行该巡检项。"
            else:
                errMsg = "\nRead-only users cannot execute this inspection item. Please log in to the system again as the administrator or super administrator and execute this inspection item again."
            return (False, cliRet, errMsg)
        
        #developer密码为空则无法巡检
        devPwd = str(javaEnv.get("devPwd").get("developer"))
        if not devPwd:
            if "zh" == lang:
                errMsg = u"\n获取developer密码为空，请确定是否已配置密码"
            else:
                errMsg = "\nThe developer password is blank. Please confirm that this password is set."
            return (False, cliRet, errMsg)
        
        if not cliModeManager.changeCli2Developer(cli, devPwd, logger):
            if "zh" == lang:
                errMsg += u"\n切换到developer模式失败。"
            else:
                errMsg += "\nFailed to switch to the developer mode."
            return (False, cliRet, errMsg)
        else:
            logger.info('Switch to developer mode successfully.')
        
        #Query LUN meta data backup service.
        for lunId in  lunIdList:
            qryLunBakupServiceCmd = DEVELOPER_CMD.SHOW_LUN_METADATA_INFO + lunId
            cmdExeSucc, devRet = cliCmdManager.execCmdWithTimout(cli, qryLunBakupServiceCmd, logger)
            cliRet += devRet
            if not cmdExeSucc or re.search('error', devRet, re.IGNORECASE):
                if "zh" == lang:
                    errMsg = u"\n查询LUN[" + lunId + u']元数据备份服务状态失败。'
                else:
                    errMsg = "\nQuery LUN[" + lunId + '] metadata backup service status failed.'
                return (False, cliRet, errMsg)
            
            lunBakServiceInfoDictList = util.formatList(devRet)
            serviceStatus = lunBakServiceInfoDictList[0]['Backup Service']
            if serviceStatus == 'Disable':
                if "zh" == lang:
                    errMsg += u"\nLUN[" + lunId + u']元数据备份服务未开启。'
                else:
                    errMsg += "\nLUN[" + lunId + '] metadata backup service is closed.'
        #For loop over
                
        if not errMsg:
            return (True, cliRet, errMsg)
        else:
            return (False, cliRet, errMsg)
    except:
        logger.error("Sequence[thickLunMetaDataBakService] catch except of trace back:" + traceback.format_exc())
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (False, cliRet, errMsg)
    else:
        pass
    finally:
        cliModeManager.changeAnyModel2Cli(cli)
        