# -*- coding: UTF-8 -*-
from time import sleep

RETRY_TIMES = 3
RETRY_INTERVAL_TIME = 5
##执行命令默认超时时间
CMD_DEFAULT_TIMEOUT = 300

def execCmdWithTimout(ssh, cmd, logger, timeout=CMD_DEFAULT_TIMEOUT):
    '''
            函数功能：执行CLI命令，如果执行过程中出现异常，SSH重连后再执行命令。
            输入参数： ssh    SSH通道
            cmd    待执行的命令
            logger 日志打印接口
            返回值：  命令执行成功与否, 命令执行结果
    '''
    
    logger.info('[cliCmdManager.py]-enter')
        
    # 重试次数
    count = 0
    # 命令执行结果
    ret = ''
    try:
        logger.info('Try to execute command: [' + cmd + '] now.')
        ret = ssh.execCmdWithTimout(cmd, timeout)
    except:
        while True:
            try:
                logger.info('[cliCmdManager.py]-reconnect to device for ' + str(count + 1) + ' times')
                ssh.reConnect()
            except:
                logger.error('[cliCmdManager.py]-reconnect to device ERR')
                pass
            else:
                logger.error('Execute command: [' + cmd + '] now.')
                ret = ssh.execCmd(cmd)
                break
            count += 1
            if count > RETRY_TIMES:
                return (False, ret)
            sleep(RETRY_INTERVAL_TIME)
    
    logger.info('[cliCmdManager.py]-execute command ' + cmd + ' successfully')
    logger.info('[cliCmdManager.py]-leave')
    return(True, ret)

def execCmd(ssh, cmd, logger):
    '''
            函数功能：执行CLI命令，如果执行过程中出现异常，SSH重连后再执行命令。
            输入参数： ssh    SSH通道
            cmd    待执行的命令
            logger 日志打印接口
            返回值：  命令执行成功与否, 命令执行结果
    '''
    
    logger.info('[cliCmdManager.py]-enter')
        
    # 重试次数
    count = 0
    # 命令执行结果
    ret = ''
    try:
        logger.info('Try to execute command: [' + cmd + '] now.')
        ret = ssh.execCmd(cmd)
    except:
        while True:
            try:
                logger.info('[cliCmdManager.py]-reconnect to device for ' + str(count + 1) + ' times')
                ssh.reConnect()
            except:
                logger.error('[cliCmdManager.py]-reconnect to device ERR')
                pass
            else:
                logger.info('Execute command: [' + cmd + '] now.')
                ret = ssh.execCmd(cmd)
                break
            count += 1
            if count > RETRY_TIMES:
                return (False, ret)
            sleep(RETRY_INTERVAL_TIME)
    
    logger.info('[cliCmdManager.py]-execute command ' + cmd + ' successfully')
    logger.info('[cliCmdManager.py]-leave')
    return(True, ret)



