#coding: UTF-8

import time
import traceback
import re
from time import sleep
import cliCmdManager
from constant import CLI_CMD

def changeCli2Developer(ssh, devPasswd, logger):
    '''
            函数名称: changeCli2Developer
            功能说明: 从CLI模式进入developer模式（需要确定使用之前为CLI模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    '''


    ret = cliCmdManager.execCmd(ssh, CLI_CMD.SWITCH_TO_DEVELOPER, logger)
    if not ret[0]:
        return False
    
    temp = ret[1]
    #判断是否已经developer模式
    if re.search("Password", temp, re.IGNORECASE):
        temp = ssh.execCmdNoLog(devPasswd)
        if re.search("developer", temp, re.IGNORECASE):
            return True
    
    #进入developer模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False

def changeCli2Diagnose(ssh, devPasswd, logger):
    '''
            函数名称: changeCli2Diagnose
            功能说明: 从CLI模式进入diagnose模式（需要确定使用之前为CLI模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    '''
        
    if not changeCli2Developer(ssh, devPasswd, logger):
        return False
    
    devRet = ssh.execCmdWithTimout("debug", 10)
    if re.search('diagnose>', devRet, re.IGNORECASE):
        return True
   
    #进入diagnose模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False 


def changeAnyModel2Cli(ssh):
    '''
            函数名称: changeAnyModel2Cli
            功能说明: 从任意模式退出到cli命令模式（不适用于心跳连接到对端的情况）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    '''
    counter = 0
    while True:
        temp = ssh.execCmdWithTimout("show system general", 10)
        #非developer模式下，cli回文正确，则认为回到了cli
        if (re.search("System Name", temp, re.IGNORECASE) and 
            not re.search("developer:", temp, re.IGNORECASE)):
                break
        #最小系统下要用login admin命令，exit会直接退出连接
        elif re.search("minisystem", temp, re.IGNORECASE):
            temp1 = ssh.execCmd("logincli")
        #os_only模式下直接退出
        elif re.search("-bash", temp, re.IGNORECASE):
            break
        #其他情况下，直接exit
        else:
            temp1 = ssh.execCmd("exit")
            if re.search("Are you sure", temp1, re.IGNORECASE):
                ssh.execCmd("y")
        
        #单控的命令模式最多4层
        counter += 1
        if counter >= 4:
            break


def changeDeveloper2Minisystem(ssh):
    '''
            函数名称: changeDeveloper2Minisystem
            功能说明: 从developer模式进入minisystem模式（需要确定使用之前为developer模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False 
    '''   
    #进入minisystem
    temp = ssh.execCmdWithTimout("minisystem", 5)

    if re.search("minisystem>", temp, re.IGNORECASE):
        return True
    
    if re.search("Are you sure", temp, re.IGNORECASE):
        temp1 = ssh.execCmd("y")

        if re.search("minisystem>", temp1, re.IGNORECASE):
            return True

    return False


def changeSafeModel2Minisystem(ssh):
    '''
            函数名称: changeSafeModel2Minisystem
            功能说明: 从safe模式切换到minisystem模式
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False    
    '''
    #直接输入minisystem命令
    temp = ssh.execCmd("minisystem")
    if re.search("minisystem>", temp, re.IGNORECASE):
        return True
    else:
        return False
    
def changeCliModel2Minisystem(ssh, devPasswd, logger):
    '''
            函数名称: changeCliModel2Minisystem
            功能说明: 从CLI模式切换到minisystem模式
            输入参数: ssh, devPasswd, logger
            输出参数: 无
            返 回 值: True or False    
    '''
        
    if not changeCli2Developer(ssh, devPasswd, logger):
        logger.error('Switch cli to developer mode failed!')
        changeAnyModel2Cli(ssh)
        return False
        
    if not changeDeveloper2Minisystem(ssh):
        logger.error('Switch developer to minisystem mode failed!')
        changeAnyModel2Cli(ssh)
        return False
    
    logger.info('Switch cli to minisystem mode successfully!')
    return True

def exitFromPeerMinisystem(ssh):
    '''
            函数名称: exitFromPeerMinisystem
            功能说明: 从safe模式切换到minisystem模式
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False    
    '''
        
    temp = ssh.execCmd("exit")
    if re.search("Are you sure to exit", temp, re.IGNORECASE):
        temp = ssh.execCmdWithTimout('y', 30)
        if re.search('closed', temp, re.IGNORECASE):
            return True    
        
    return False 