#-*- coding:utf-8 -*-
import util
import cliCmdManager
from constant import CLI_CMD

def getProductFullVersion(cli, logger):
    """
    Function name      : getUserLevel
    Function describe  : get user level
    Input              : (cli, logger)
    Return             : (cmdExecuteSuccess, cliRet, productVersion)
    """    
    cmdExeSucc, cliRet = cliCmdManager.execCmdWithTimout(cli, CLI_CMD.SHOW_UPGRADE_PACKAGE, logger)
    if not cmdExeSucc:
        return (False, cliRet, '')
    
    endIndex = cliRet.find('HotPatch Version')
    if endIndex == -1:
        return (False, cliRet, '')
    
    try:
        dictList = util.formatList(cliRet[:endIndex])
        fullVersion = dictList[0]['Current Version']
    except:
        return (False, cliRet, '')
    else:
        return (True, cliRet, fullVersion)
    
    
def getUserLevel(userName, cli, logger):
    """
    Function name      : getUserLevel
    Function describe  : get user level
    Input              : (userName, cli, logger)
    Return             : (cmdExecuteSuccess, cliRet, userLevel)
    """    
    qryUserLvlCmd = CLI_CMD.SHOW_USER + userName
    cmdExeSucc, cliRet = cliCmdManager.execCmdWithTimout(cli, qryUserLvlCmd, logger)
    if not cmdExeSucc:
        return (False, cliRet, '')
    
    try:
        dictList = util.formatList(cliRet)
        usrLvl = dictList[0]['Level']
    except:
        return (False, cliRet, '')
    else:
        return (True, cliRet, usrLvl)
    
def getLunIDList(cli, logger):
    """
    Function name      : getLunIDList
    Function describe  : get LUN id list.
    Input              : (cli, logger)
    Return             : (cmdExecuteSuccess, cliRet, lunIdList)
    """    
        
    cmdExeSucc, cliRet = cliCmdManager.execCmdWithTimout(cli, CLI_CMD.SHOW_LUN_GENERAL, logger)
    if not cmdExeSucc:
        return (False, cliRet, [])
   
    lunIdList = [] 
    try:
        lunInfoDictList = util.formatList(cliRet)
        for lunInfoDict in lunInfoDictList:
            lunIdList.append(lunInfoDict['ID'])
    except:
        return (False, cliRet, lunIdList)
    else:
        return (True, cliRet, lunIdList)

