# -*- coding: UTF-8 -*-
import traceback
import os
import cliCmd

def execute(devObj):
    '''
    @summary: 收集设备上config.txt文件
    '''
    try:
        
        #为每套设备创建文件存放文件夹
        tmpDataDir = devObj.get("tmpDataDir")
        devIp = py_java_env.get("devInfo").getIp()
        #IPV6替换:为.否则创建文件夹失败
        devIp = str(devIp).replace(":", ".")                               
        devSN = py_java_env.get("devInfo").getDeviceSerialNumber()
        localFileDir = tmpDataDir + os.path.sep + "data" + os.path.sep + "config" + os.path.sep + devIp + "_" + devSN
        if not os.path.exists(localFileDir):
            os.makedirs(localFileDir)
                
        #触发设备收集
        ssh = devObj.get("ssh")
        cmd = "show file export_path file_type=running_data"
        cliRet = ssh.execCmdNoLogTimout(cmd, 2*60)
        
        #下载文件
        remoteFile = cliRet.splitlines()[1].split(":")[1].strip()
        sftp = devObj.get("sftp")
        sftp.getFile(remoteFile, localFileDir, None)
        
        #删除设备上文件
        sftp.deleteFile(remoteFile)
        
        #收集clicmd文件(忽略异常)
        try:
            cliCmdFileDir = os.path.join(tmpDataDir, "data", "Other", devIp + "_" + devSN)
            #创建文件夹
            if not os.path.exists(cliCmdFileDir):
                os.makedirs(cliCmdFileDir)
            devObj["logger"] = PY_LOGGER
            cliCmd.collectCliCmd(devObj, cliCmdFileDir)
        except:
            PY_LOGGER.error("Failed to collect cliCmd:" + str(traceback.format_exc()))
        return ("", dict(flag=True, des=""))
    except:
        PY_LOGGER.error("Failed to collect running file, because %s" % str(traceback.format_exc()))
        #后台收集，忽略失败
        return ("", dict(flag=True, des=""))
    
    