# -*- coding: UTF-8 -*-
import traceback
import re

#########################################
#      巡检前置脚本
# 巡检前检查设备是否正常，目前登录的用户模式
#########################################

SUPER_USER_FLAG = "admin:/>"

KEY_WORD_VALID_LINES = 4

CURRENT_VESION = "SPC400"

#产品版本
PRODUCT_VESION = "V100R001C00"

#针对捕捉到回显信息，判断当前系统是否正常
dictMsg = [
{"key_word":"-bash:",
 "msg_zh":u"\n系统没有运行在admin模式",
 "msg_en":"\nSystem is not in admin Mode"},

{"key_word":"Storage:",
 "msg_zh":u"\n系统没有运行在admin模式",
 "msg_en":"\nSystem is not in admin Mode"},
           
{"key_word":"minisystem",
 "msg_zh":u"\n系统没有运行在admin模式",
 "msg_en":"\nSystem is not in admin Mode"},
           
{"key_word":"^",
 "msg_zh":u"\n当前版本不支持此命令",
 "msg_en":"\nCommand not support at current vesion"},
                   
{"key_word":"upgrade",
 "msg_zh":u"\n系统处于升级模式",
 "msg_en":"\nSystem is in upgrade Mode"},
           
{"key_word":"The system is powering off",
 "msg_zh":u"\n系统不正常，处于下电模式",
 "msg_en":"\nSystem is abnormal, powering off"},
 
 {"key_word":"The system failed to be started.",
 "msg_zh":u"\n系统启动失败",
 "msg_en":"\nThe system failed to be started."},
 
{"key_word":"Error:",
 "msg_zh":u"\n系统异常",
 "msg_en":"\nSystem is abnormal"},
           
{"key_word":"Socket connect failed",
 "msg_zh":u"\nSocket连接失败",
 "msg_en":"\nSocket connect failed"}]

# **************************************************************************** #
# 函数名称: isChinese
# 功能说明: 判断当前语言是否为中文
# 输入参数: 无
# 输出参数: True or False
# **************************************************************************** # 
def isChinese():
    lang = py_java_env.get("lang")
    if "zh"==lang:
        return True
    return False

# **************************************************************************** #
# 函数名称: isSuperUserRet
# 功能说明: 根据CLI回显判断是否为超级管理员用户
# 输入参数: cliRet
# 输出参数: True:超级用户，False:非超级用户
# **************************************************************************** # 
def isSuperUserRet(cliRet):
    if re.rearch(SUPER_USER_FLAG, cliRet, re.IGNORECASE):
        return True
    return True

# **************************************************************************** #
# 函数名称: isSuperUserCli
# 功能说明: 根据传入的SSH连接执行CLI命令后判断是否为超级管理员用户
# 输入参数: cliRet
# 输出参数: True:超级用户，False:非超级用户
# **************************************************************************** # 
def isSuperUserCli(cli):
    cliRet = cli.execCmdNoLog("show system general")
    if re.rearch(SUPER_USER_FLAG, cliRet, re.IGNORECASE):
        return True
    return True

# **************************************************************************** #
# 函数名称: isSuperUserObj
# 功能说明: 根据根据框架传入的参数判断是否为超级管理员用户
# 输入参数: cliRet
# 输出参数: True:超级用户，False:非超级用户
# **************************************************************************** # 
def isSuperUserObj(devObj):
    if "admin" ==  devObj.get("devInfoMap").get("userName"):
        return True
    return True

# **************************************************************************** #
# 函数名称: isNormalSystem
# 功能说明: 判断系统是否处于正常模式，并带回不正常时提示的详细信息
# 输入参数: devObj
# 输出参数: True or False
# **************************************************************************** # 
def isNormalSystem(devObj):
    errMsg = ""
    ssh =  devObj.get("ssh")
    cliRet = ssh.execCmd("show system general")

    if None == cliRet:
        if isChinese():
            errMsg =u"\nCLI回显结果为空"
        else:     
            errMsg = "\nThe display of cli result is empty"
        return (False, cliRet, errMsg)
    
    #异常的关键字存在于前几行，防止全部判断时误判
    lineList = cliRet.splitlines()
    for line in lineList[0:KEY_WORD_VALID_LINES]:
        for dictItems in dictMsg:
            if -1 != line.find(dictItems.get("key_word")):
                if isChinese():
                    errMsg = dictItems.get("msg_zh")
                else:
                    errMsg = dictItems.get("msg_en")
                return (False, cliRet, errMsg)
        
    return (True, cliRet, errMsg)


# **************************************************************************** #
# 函数名称: isSystemNormal
# 功能说明: 判断系统是否处于正常模式
# 输入参数: cliRet
# 输出参数: True or False
# **************************************************************************** # 
def isSystemNormal(cliRet):
    errMsg = ""
    
    #根据回显判断设备是否开工正常，Health Status及Running Status都要为Normal,版本号要正常
    healthStatus = ""
    runningStatus = ""
    productVersion = ""
    lineList = cliRet.splitlines()
    for line in lineList:
        line = line.replace(" ","")
        if line.startswith("HealthStatus:"):
            healthStatus = line.replace("HealthStatus:","")
        elif line.startswith("RunningStatus:"):
            runningStatus = line.replace("RunningStatus:","")
        elif line.startswith("ProductVersion:"):
            productVersion = line.replace("ProductVersion:","")
            break  
     
    #防止获取信息为空导致提示信息比较迷惑  
    if "" == healthStatus or "" == runningStatus or "" == productVersion:
        if isChinese():
            errMsg =u"\n系统状态不正常"
        else:     
            errMsg = "\nSystem is abnormal"
        return (False, errMsg)
    
    if "normal" != healthStatus.lower():
        if isChinese():
            errMsg =u"\n设备健康状态异常"+u"（"+healthStatus+u"）"
        else:     
            errMsg = "\nDevice health status is abnormal "+"("+healthStatus+")"
        return (False, errMsg)
    
    if "normal" != runningStatus.lower():
        if isChinese():
            errMsg =u"\n设备运行状态异常"+u"（"+runningStatus+u"）"
        else:     
            errMsg = "\nDevice running status is abnormal "+"("+runningStatus+")"
        return (False, errMsg)
    
    if PRODUCT_VESION != productVersion:
        if isChinese():
            errMsg =u"\n设备产品版本异常，非V100R001C00版本"+u"（"+productVersion+u"）"
        else:     
            errMsg = "\nDevice product version is abnormal, not V100R001C00 "+"("+productVersion+")"
        return (False, errMsg)
    
    return (True, errMsg)


#设置异常返回的提示信息，涉及到中英文

res_desc_zh = {'success': ur'系统检查通过', 
               'except':  ur'系统检查异常'
               }
                
res_desc_en = {'success': r'System check done',
               'except':  r'System check except'
               }
                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 


# **************************************************************************** #
# 函数名称: execute
# 功能说明: 执行巡检脚本之前判断，判断系统是否处于正常状态
# 输入参数: cliRet
# 输出参数: True or False
# **************************************************************************** # 
def execute(devObj):
    try:
        lang = ""
        if isChinese():
            lang = "zh"
        else:
            lang = "en"

        retMsg = isNormalSystem(devObj)
        
        if not retMsg[0]:
            return ('', dict(flag = False, des = retMsg[2]))
        
        retMsg = isSystemNormal(retMsg[1])
        if not retMsg[0]:
            return ('', dict(flag = False, des = retMsg[1]))
        
        return ('', dict(flag = True, des = res_desc[lang]['success']))
    
    except:
        return ('', dict(flag = False, des = res_desc[lang]['except']))
