# -*- coding: UTF-8 -*-
import traceback
import common
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show system general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet = ""
        errMsg = ""
        
        
        #执行的CLI命令
        cmd = "show controller general"
        PY_LOGGER.info("Sequence[1] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]: 
            PY_LOGGER.info("Sequence[1] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        
        list = cliRet.splitlines()
        i = 0;j=0
        engineList = []
        for field in list:
            field = field.replace(" ","")
            if field.startswith("Controller:"):
                ctrlId = field.replace("Controller:","")
                #从控制器ID中获取控制器所在的引擎ID，并存放到列表engineList中
                engineId = ctrlId[0]
                engineList.append(engineId)
                continue
                
            if field.startswith("HealthStatus"):
                if field.replace("HealthStatus:","") != "Normal":
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n控制器["+ctrlId+u"]健康状态检查异常"
                    else:
                        errMsg += "\nThe health status of Controller ["+ctrlId+"] is abnormal"
                i = i + 1
                continue
                
            if field.startswith("RunningStatus"):
                if field.replace("RunningStatus:","") != "Online":
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n控制器["+ctrlId+u"]运行状态检查异常"
                    else:
                        errMsg += "\nThe running status of Controller ["+ctrlId+"] is abnormal"
                j = j + 1
                continue
                
        if i%2 == 1 or j%2 == 1:
            flag = False
            PY_LOGGER.info("Sequence[1] controller check fail. Health Status num is:" + str(i) + ". Running Status num is:" +str(j)+"~~~over!")
            if "zh" == lang:
                errMsg = u"\n系统可能处于单控状态"
            else:
                errMsg = "\nSystem may be in single status"
            return (flag, cliRet, errMsg)
        
        PY_LOGGER.info(u"all engine id:"+str(engineList))
        for engine in engineList:
            count = engineList.count(engine)
            #如果某个引擎出现的次数为奇数，则说明该引擎下的控制器数量不符合规范
            if count % 2 != 0:
                flag = False
                if "zh" == lang:
                    errMsg = u"\n可能存在离线的控制器"
                else:
                    errMsg = "\nThe controller of the system may be offline"
                PY_LOGGER.info(u"engine "+str(engine)+" has "+str(count)+" controllers")
        
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[1] catch except of check controller status.")
        PY_LOGGER.error("Sequence[1] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[1] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[1] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
            
        return (flag, cliRet, errMsg)
