# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showiscsiber")
    Return             : the checkitem is pass;cli source info
    """
    lang = py_java_env.get("lang")
    cliRet = ""
    try:
        flag = True
    	errMsg = ""

        #执行的CLI命令
        cmd = "show port fibre_module|filterColumn include columnList=PortID,Health\sStatus,Model"
        PY_LOGGER.info("Sequence[10] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[10] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        list = cliRet.splitlines()
        
        #增加光模块不在位判断
        if common.isExecSuccess(cliRet) or len(list) <= 3:
            flag = True
            return (flag, cliRet)
        
        i = 0
        for field in list:        
            i = i + 1
            if i >= 5:
                list2 = field.split()
                if common.isEndLine(field):
                    break
                
                if common.isSkipLineWithContain(field, ["PortID","-------"]):
                    continue
                
                if len(list2) < 2:
                    continue
                
                portId = list2[0]
                if list2[1] != "Normal":
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n端口["+portId+u"]状态检查异常"
                    else:
                        errMsg += "\nThe status of port ["+portId+"] is abnormal"
                        
        if not flag:
              PY_LOGGER.info("Sequence[10] inspect not pass.")
                                       
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[10] catch except of check fibre module.")
        PY_LOGGER.error("Sequence[10] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[10] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[10] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
