# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showfcber")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""
            
        #执行的CLI命令
        cmd = "show controller general"
        PY_LOGGER.info("Sequence[11] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[11] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        
        list = cliRet.splitlines()
        for field in list:          
            field = field.replace(" ","")
            if field.startswith("Controller:"):
                list2 = field.split(":")
                
                if len(list2)<2:
                    break
                
                controller = str(list2[1])
    
            if field.startswith("AllTemperatures(Celsius)"):
                list2 = field.split(":")
                
                if len(list2)<2:
                    break
                     
                #Get temperatrues of four points: CPU, in, out1, out2
                list3 = str(list2[1]).split(",")
                tempCPU = int(list3[0])
                tempIN = int(list3[1])

                if(tempCPU > 85):
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n控制器["+controller+u"] CPU温度超过85摄氏度"
                    else:
                        errMsg += "\nThe CPU temperature of controller["+controller+u"] exceed 85 celsius"

                if(tempIN > 52):
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n控制器["+controller+u"] 温控检测点温度超过52摄氏度"
                    else:
                        errMsg += "\nThe temperature monitoring point of controller["+controller+u"] exceed 52 celsius"
        if not flag:
             PY_LOGGER.info("Sequence[11] inspect not pass.")
             
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[11] catch except of check controller temperature.")
        PY_LOGGER.error("Sequence[11] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[11] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[11] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
