# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showsasber")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""

        #执行的CLI命令
        cmd = "show enclosure"
        PY_LOGGER.info("Sequence[12] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[12] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        
        i = 0
        list = cliRet.splitlines()
        for field in list:      
            list2 = field.split()
            if field.find("----") !=-1 or field.find("ID") !=-1:
                continue         
            list2 = field.split()
            if len(list2) < 5:
                continue
        
            if "--" == list2[len(list2)-1]:
                continue
            temperature = int(list2[len(list2)-1])
            if temperature > 70:
                flag = False
                if "zh" == lang:
                    errMsg += u"\nID["+list2[0]+u"]温度超过70摄氏度"
                else:
                    errMsg += "\nThe temperature of ID["+list2[0]+"] exceed 70 celsius"
                    
        if not flag:
             PY_LOGGER.info("Sequence[12] inspect not pass.")
             
        return (flag, cliRet, errMsg)
    except:
        PY_LOGGER.error("Sequence[12] catch except of check enclosure temperature.")
        PY_LOGGER.error("Sequence[12] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[12] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[12] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
