# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showprdsession")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        chkmgt_start = False
        lang = py_java_env.get("lang")
    	errMsg = ""
        #Optimize check rate
        cliRet = "default"
        cliRet = py_java_env.get("showPortGeneral")
        if None == cliRet or "default" == cliRet:
            #执行的CLI命令
            cmd = "show port general"
            PY_LOGGER.info("Sequence[16] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                PY_LOGGER.info("Sequence[16] inspect not pass. (system abnormal!)")
                return (False, cliRet, errMsg)
            py_java_env.put("showPortGeneral", cliRet)
        else:
             PY_LOGGER.info("Sequence[16] begin to inspect, get cli result form java.")
        
        
        list = cliRet.splitlines()
        for field in list:
            #找到ETH port信息区时，设置处理标志
            if field.find("ETH port:") != -1:
                chkmgt_start = True
                
            #遍历所有命令回显行，但仅处理ETH port部分，其他端口信息不处理
            if field.find("FC port:") != -1 or field.find("SAS port:") != -1 \
                or  field.find("COM port:") != -1 or field.find("FCoE port:") != -1:
				chkmgt_start = False
                
            if chkmgt_start:
					#端口可能因为超时，socket连接失败等查询失败，此种情况直接返回不通过 
                    checkLine = common.isNormalLine(field,lang) 
                    if not checkLine[0]: 
                        flag = False 
                        errMsg = checkLine[1] 
                        return (flag, cliRet, errMsg) 
                    
                    checkBlack = common.isLineInBlackDict(field,lang) 
                    if checkBlack[0]: 
                        PY_LOGGER.info("Sequence[16] inspect not pass. (system abnormal!)")
                        errMsg = checkBlack[1] 
                        return (False, cliRet, errMsg)
                    
					#跳过非管理网口信息行
                    if field.find("Management Port") == -1 or -1 != field.find("----"):
						continue
                        
                    list2 = field.split()
                    if len(list2)<4: #容错
                        PY_LOGGER.info("Sequence[16]: line with len lt 4: " + field)
                        continue
                    
                    #跳过未连接的端口
                    if "Up"!=list2[3]:
                        continue
                    
					#已连接的端口健康状态也必须正常
                    if "Normal"!=list2[1] :
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\n管理网口["+list2[0]+u"]状态检查异常"
                        else:   
                            errMsg += "\nThe status of management port ["+list2[0]+"] is abnormal" 
                        continue
					
					#正常连接的端口速率必须在允许的范围内
                    if list2[-1] not in ["100","1000"]:
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\n管理网口["+list2[0]+u"]速率异常"
                        else:
                            errMsg += "\nThe speed of management port ["+list2[0]+"] is abnormal"
        
        if not flag:
             PY_LOGGER.info("Sequence[16] inspect not pass.")
             
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[16] catch except of check manage port port.")
        PY_LOGGER.error("Sequence[16] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[16] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[16] catch except of trace back:" + str(traceback.format_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)

