# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showrmtlink")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        chk_start =False
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""
        type = "default"
        inDeveloper = False
        
        retInfo= common.change2Developer(cli, py_java_env)
        cliRet = retInfo[1]
        errMsg = retInfo[2]
        if not retInfo[0]:
            common.anyModel2Cli(cli)
            PY_LOGGER.info("Sequence[19] inspect not pass. (can't enter to developer model!)")
            return(False, cliRet, errMsg)  
        inDeveloper = True
            
        #执行的CLI命令
        cmd = "show port bit_error"
        PY_LOGGER.info("Sequence[19] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[19] inspect not pass. (system abnormal!)")
            common.anyModel2Cli(cli)
            inDeveloper = False
            return (False, cliRet, errMsg)
        inDeveloper = True
        
        list = cliRet.splitlines()
        sasId=""
        for field in list:    
            if -1!=field.find("SAS port"):
                chk_start = True
            if -1!=field.find("ETH port") or -1!=field.find("FC port") \
                or  field.find("FCoE port") != -1:
                chk_start = False

            if chk_start == True:
                
                checkBlack = common.isLineInBlackDict(field,lang)
                
                if checkBlack[0]:
                    PY_LOGGER.info("Sequence[19] inspect not pass. (system abnormal!)")
                    errMsg = checkBlack[1]
                    common.anyModel2Cli(cli)
                    inDeveloper = False
                    return (False, cliRet, errMsg)
                list2 = field.split()
                if len(list2) < 6:
                    continue
                if -1!=field.find("SAS port") or -1!=field.find("ID") or -1!=field.find("-------"):
                    continue

                for index in range(1, 5):
                    if "0"!=list2[index] and -1==list2[index].find("--"):
                        flag = False
                        sasId = list2[0]
                        if 'zh' == lang:
                            errMsg += u"\nSAS口["+sasId+u"]存在误码"
                        else:
                            errMsg += "\nThe SAS port ["+sasId+"] exist error bits"
                        break
                    
        if inDeveloper == True:
            common.anyModel2Cli(cli)
            inDeveloper = False 

        if not flag:
             PY_LOGGER.info("Sequence[19] inspect not pass.")
             
        return (flag, cliRet, errMsg)
    except Exception, exception:
        PY_LOGGER.error("Sequence[19] catch except of check host port error.")
        PY_LOGGER.error("Sequence[19] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[19] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[19] catch except of trace back:" + str(traceback.print_exc()))
        if inDeveloper == True:
            common.anyModel2Cli(cli)
            inDeveloper = False
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
