# -*- coding: UTF-8 -*-
import traceback
import common
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showexpmodule")
    Return             : the checkitem is pass;cli source info
    """
    try:
    	flag = True
    	lang = py_java_env.get("lang")
    	errMsg = ""
    	cliRet = ""
    	
        cmd = "show enclosure"
        PY_LOGGER.info("Sequence[21] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[21] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        
    	list = cliRet.splitlines()
        
    	for field in list:
            if field.find("Data Switch") != -1:
                list2 = field.split()
                frameId = list2[0]
                if list2[3] != "Normal":
                    flag = False
                    PY_LOGGER.info("Sequence[21] Health Status is:"+list2[3]+".~~~over!")
                    if "zh" == lang:
                        errMsg += u"\n交换机["+frameId+u"]健康状态异常"
                    else:
                        errMsg += "\nThe health status of Data Switch["+frameId+"] is abnormal"
                if list2[4] != "Online":
                    flag = False
                    PY_LOGGER.info("Sequence[21] Running Status is:"+list2[4]+".~~~over!")
                    if "zh" == lang:
                        errMsg += u"\n交换机["+frameId+u"]运行状态检查异常"
                    else:
                        errMsg += "\nThe running status of Data Switch["+frameId+"] is abnormal"
                        
        if not flag:
             PY_LOGGER.info("Sequence[21] inspect not pass.")
             
    	return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[21] catch except of check enclosure status.")
        PY_LOGGER.error("Sequence[21] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[21] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[21] catch except of trace back:" + str(traceback.print_exc()))
        falg = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
