# -*- coding: UTF-8 -*-
import traceback
import common
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showrmtlink")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        chk_start =False
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = ""
        type = "default"
        inDeveloper = False
        
        retInfo= common.change2Developer(cli, py_java_env)
        cliRet = retInfo[1]
        errMsg = retInfo[2]
        if not retInfo[0]:
            common.anyModel2Cli(cli)
            PY_LOGGER.info("Sequence[23] inspect not pass. (can't enter to developer model!)")
            return(False, cliRet, errMsg)  
        inDeveloper = True

        #执行的CLI命令
        cmd = "show port bit_error"
        PY_LOGGER.info("Sequence[23] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[23] inspect not pass. (system abnormal!)")
            common.anyModel2Cli(cli)
            inDeveloper = False
            return (False, cliRet, errMsg)
        
        cmd0 = "show controller general"
        controllerCount = 0
        
        checkRet0 = common.isCliExecRetInBlackList(cli,cmd0,lang,True)
        cliRet0 = checkRet0[1]
        errMsg = checkRet0[2]
        if checkRet0[0]:
            PY_LOGGER.info("Sequence[22] inspect not pass. (system abnormal!)")
            return (False, cliRet0, errMsg)
        
        list0 = cliRet0.splitlines()
        for field in list0:
            field = field.replace(" ","")
            if field.startswith("Controller:"):
                ctrlId = field.replace("Controller:","")
                if ctrlId != "" and ctrlId != " " and (ctrlId.find("A")!=-1 or ctrlId.find("B")!=-1):
                    controllerCount = controllerCount + 1
                continue
        
        inDeveloper = True   
        pcieCount = 0
        
        list = cliRet.splitlines()
        for field in list:
            
            if field.find("PCIE port") != -1:
                chk_start = True
                pcieCount =pcieCount + 1
                PY_LOGGER.info("Sequence[23] change flag to true~~~over!"+field)
            if field.find("ETH port") != -1 or field.find("FC port") != -1 \
            or field.find("FCoE port") != -1 or field.find("ETH port") != -1  or field.find(":/>") != -1:
                chk_start = False
                PY_LOGGER.info("Sequence[23] change flag to false~~~over!"+field)
            if chk_start == True:
                pcieCount =pcieCount + 1
                
                if field.find("---") != -1 or field.find("ID") != -1 :
                    continue
                
                checkBlack = common.isLineInBlackDict(field,lang)
                
                if checkBlack[0]:
                    PY_LOGGER.info("Sequence[23] inspect not pass. (system abnormal!)")
                    errMsg = checkBlack[1]
                    common.anyModel2Cli(cli)
                    inDeveloper = False
                    return (False, cliRet, errMsg)
                
                list2 = field.split()
                if len(list2) < 7:
                    continue
                for index in range(1, 6):
                    if "0"!=list2[index] and -1==list2[index].find("--"):
                        flag = False
                        sasId = list2[0]
                        if 'zh' == lang:
                            errMsg += u"\nPCIE端口("+list2[0]+u")存在误码"
                        else:
                            errMsg += "\nThe PCIE port("+list2[0]+") exist error bits"
                        break
        
        #检查PCIE端口是否存在
        if pcieCount <= 2:
            if controllerCount > 2:
                flag = False
                PY_LOGGER.info("Sequence[23] there is no pcie port!")
                if "zh" == lang:
                    errMsg = u"\nPCIE端口不在位"
                else:
                    errMsg = "\nThe port of PCIE does not exist"
        
        if not flag:
             PY_LOGGER.info("Sequence[23] inspect not pass.")
             
        if inDeveloper == True:
            common.anyModel2Cli(cli)
            inDeveloper = False
            
        return (flag, cliRet, errMsg)
                
    except Exception, exception:
        PY_LOGGER.error("Sequence[23] catch except of check host port error.")
        PY_LOGGER.error("Sequence[23] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[23] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[23] catch except of trace back:" + str(traceback.print_exc()))
        if inDeveloper == True:
            common.anyModel2Cli(cli)
            inDeveloper = False
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
