# -*- coding: UTF-8 -*-
import traceback
import common
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show system general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = ""
        
        cmd = "show disk health"
        PY_LOGGER.info("Sequence[27] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[27] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        
        list = cliRet.splitlines()
        
        diskID = ""
        
        for field in list:
            field = field.replace(" ","")
            
            if field.find("----") != -1 :
                diskID = ""
                continue
                
            if field.startswith("DiskID:"):
                diskID = field.replace("DiskID:","")
                
            if field.startswith("HealthMark"):
                if field.replace("HealthMark:", "") == "--" :
                    continue
                if field.replace("HealthMark:", "") == " " or field.replace("HealthMark:", "") == "":
                    flag = False
                    PY_LOGGER.info("Sequence[27] Health Mark is:" + field + "~~~over!")
                    if "zh" == lang:
                        errMsg += u"\nDisk ID["+diskID+u"]硬盘健康状态不正常"
                    else:
                        errMsg += u"\nDisk ID["+diskID+"] Disk's health mark is abnormal"
                    continue
                if int(field.replace("HealthMark:","")) <= 60:
                    flag = False
                    PY_LOGGER.info("Sequence[27] Health Mark is:" + field + "~~~over!")
                    if "zh" == lang:
                        errMsg += u"\nDisk ID["+diskID+u"]硬盘健康状态不正常"
                    else:
                        errMsg += u"\nDisk ID["+diskID+"] Disk's health mark is abnormal"
                    
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[27] catch except of check controller status.")
        PY_LOGGER.error("Sequence[27] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[27] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[27] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
            
        return (flag, cliRet, errMsg)
