# -*- coding: UTF-8 -*-
import traceback
import common
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show system general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = ""
        
        cmd = "show disk routine_test"
        PY_LOGGER.info("Sequence[28] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[28] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        
        list = cliRet.splitlines()
        
        for field in list:
            field = field.replace(" ","")
            
            if field.startswith("EnableRoutineTest:"):
                if field.replace("EnableRoutineTest:","") != "On":
                    flag = False
                    PY_LOGGER.info("Sequence[28] Enable Routine Test is:" + field + "~~~over!")
                    if "zh" == lang:
                        errMsg += u"\n硬盘例测周期状态不正常("+field+u")"
                    else:
                        errMsg += "\nDisk's routine test is abnormal("+field+")"
                    return (flag, cliRet, errMsg)
                
            if field.startswith("RoutineTestPeriod:"):
                if field.replace("RoutineTestPeriod:","") == "--" or field.replace("RoutineTestPeriod:","") == "" or \
                field.replace("RoutineTestPeriod:","") == " " or int(field.replace("RoutineTestPeriod:","").replace("Minute", "")) < 1:
                    flag = False
                    PY_LOGGER.info("Sequence[28] Routine Test Period is:" + field + "~~~over!")
                    if "zh" == lang:
                        errMsg += u"\n硬盘例测周期状态不正常("+field+u")"
                    else:
                        errMsg += "\nDisk's routine test is abnormal("+field+")"
                    return (flag, cliRet, errMsg) 
        return (flag, cliRet)

    except Exception, exception:
        PY_LOGGER.error("Sequence[28] catch except of check controller status.")
        PY_LOGGER.error("Sequence[28] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[28] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[28] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
            
        return (flag, cliRet, errMsg)
