# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showpower")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        i = 0
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""

        #执行的CLI命令
        cmd = "show power_supply"
        PY_LOGGER.info("Sequence[3] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[3] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        
        list = cliRet.splitlines()
        for field in list:
            i = i + 1
            if i >= 5:
                if common.isEndLine(field):
                    break
                
                list2 = field.split()
                if (-1==field.find("Normal")) or (-1==field.find("Online")) or (-1!=field.find("Fault")) or ((-1!=field.find("No Input"))) \
                    or (-1!=field.find("Offline")) or (-1!=field.find("Not Running")):
                    flag = False
                    if len(list2)>0:
                        if "zh" == lang:
                            errMsg += u"\n电源ID[" + list2[0] + u"]状态检查异常"
                        else:
                            errMsg += "\nThe status of power supply[" + list2[0] + "] is abnormal"
                            
        if not flag:
             PY_LOGGER.info("Sequence[3] inspect not pass.")

        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[3] catch except of check power_supply.")
        PY_LOGGER.error("Sequence[3] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[3] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[3] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
