# -*- coding: UTF-8 -*-
import traceback
import common
import re

def getBBUNumDict(cli):
    ctrlNum = 0
    cliRet = cli.execCmd("show controller general")
    list = cliRet.splitlines()

    for field in list:
        field = field.replace(" ","")
        if field.startswith("Controller:"):
            ctrlNum = ctrlNum + 1
            continue
    # 控制器BBU标准规格    
    if ctrlNum%2 == 0:
        standardBbuNum = (ctrlNum/2)*4       
    else:
        standardBbuNum = ((ctrlNum/2)+1)*4
    return standardBbuNum  



def checkBbuNum(cli, flag, errMsg, cliRet4Bbu):
    bbuNumDict = {}
    cliRet4SysInfo = cli.execCmd("show system general")
    PY_LOGGER.info("\nSequence[4] execute command result for system:\n" + cliRet4SysInfo)
    cliRet4SysInfoList = cliRet4SysInfo.splitlines()
    lang = py_java_env.get("lang")
    pdtModel = ""
    #能查询到系统信息
    if re.search("System Name", cliRet4SysInfo, re.IGNORECASE):
        #获取产品型号
        for line in cliRet4SysInfoList:
            if re.search("Product Model", line, re.IGNORECASE):
                pdtModel = (line.split(":")[1]).strip()
                break
    else:
        for line in cliRet4SysInfoList:
            #系统没有运行在admin模式
            if line.startswith("-bash") or line.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[4] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet4SysInfo, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", line, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[4]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet4SysInfo, errMsg)
            
    #无法获取产品型号
    if "" == pdtModel:
        flag = False
        PY_LOGGER.info("Sequence[4] cannot get product model.")
        if "zh" == lang:
            errMsg += u"\n无法获取产品型号。"
        else:
            errMsg += "\nCannot get product model."
    else:
        #根据产品型号获取标准BBU个数
        standardBbuNum = 0
        standardBbuNum = getBBUNumDict(cli)
       
        
        #获取真实BBU个数
        cliRet4BbuList = cliRet4Bbu.splitlines()
        count4Bbu = 0
        isCounterSwitchOn = False
        for line in cliRet4BbuList:
            #如果找到列分隔符"---"，就打开计数开关，并在下一行开始计数
            if re.search("---", line, re.IGNORECASE):
                isCounterSwitchOn = True
                continue
            #如果找到“:/>”，就关闭计数开关，并退出循环
            if re.search(":/>", line, re.IGNORECASE):
                isCounterSwitchOn = False
                break
            #如果是空行，则不计数
            if "" == line.strip():
                continue
            #如果计数开关打开，则开始计数
            if isCounterSwitchOn:
                count4Bbu += 1
        
        #比较真实BBU个数和标准BBU个数是否一致
        if count4Bbu != standardBbuNum:
            flag = False
            PY_LOGGER.info("Sequence[4] BBU number is not enough.")
            if "zh" == lang:
                errMsg += u"\nBBU个数不足。"
            else:
                errMsg += "\nBBU number is not enough."
    return (flag, cliRet4SysInfo, errMsg)



def execute(cli):
    """
    Create date        : 2012/05/18 
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showbbu")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        i = 0
        lang = py_java_env.get("lang")
        cliRet = ""
        errMsg = ""
        
        #执行的CLI命令
        cmd = "show bbu general"
        PY_LOGGER.info("Sequence[4] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[4] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        
        list = cliRet.splitlines()
        #增加BBU不在位判断
        if common.isExecSuccess(cliRet) or len(list) <= 3:
            flag = False
            if "zh" == lang:
                errMsg += u"\nBBU不在位"
            else:
                errMsg += "\nThe BBU cannot be detected."
            return (flag, cliRet, errMsg)
        
        bbuId=""
        for field in list:         
            i = i + 1
            if i >= 5:
                list2 = field.split()
                if len(list2) < 5:
                    continue

                #health status要为Normal
                if -1==field.find("normal") and -1==field.find("Normal"):
                    flag = False
                    bbuId = list2[0]
                    if "zh" == lang:
                        errMsg += u"\nBBU[" + bbuId + u"]健康状态检查异常"
                    else:
                        errMsg += "\nThe health status of BBU [" + bbuId + "] is abnormal"
                
                #runnig status要为Charging，Discharging或Online
                if -1==field.find("charging") and -1==field.find("discharging") and -1==field.find("online")\
                    and -1==field.find("Charging") and -1==field.find("Discharging") and -1==field.find("Online"):
                    flag = False
                    bbuId = list2[0]
                    if "zh" == lang:
                        errMsg += u"\nBBU[" + bbuId + u"]运行状态检查异常"
                    else:
                        errMsg += "\nThe running status of BBU [" + bbuId + "] is abnormal"
         #检测BBU个数是否达标
        retTuple = checkBbuNum(cli, flag, errMsg, cliRet)
        flag = retTuple[0]
        errMsg = retTuple[2]
        if not flag:
             PY_LOGGER.info("Sequence[4] inspect not pass.")
             
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[4] catch except of check bbu status.")
        PY_LOGGER.error("Sequence[4] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[4] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[4] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
