# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check product version
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show system general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = False
        lang = py_java_env.get("lang")
        cliRet = "default"
    	errMsg = ""
        #Optimize check rate
        cliRet = py_java_env.get("showSystemGeneral")
        if None == cliRet or "default" == cliRet:
            #执行的CLI命令
            cmd = "show system general"
            PY_LOGGER.info("Sequence[41] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                PY_LOGGER.info("Sequence[41] inspect not pass. (system abnormal!)")
                return (False, cliRet, errMsg)
            py_java_env.put("showSystemGeneral", cliRet)
        else:
             PY_LOGGER.info("Sequence[41] begin to inspect, get cli result form java.")

        list = cliRet.splitlines()
        for field in list:
            field = field.replace(" ", "")         
            if field.startswith("ProductVersion"):
                if field.replace("ProductVersion:", "").find("V100R001C10") != -1:
                    flag = True
                    return (flag, cliRet)
                else:
                    PY_LOGGER.info("Sequence[41] Inspect product version is: " + field)
                    
        if "zh" == lang:
            errMsg = u"\n系统版本异常"
        else:
            errMsg = "\nThe version of system is not correct"
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[41] catch except of check product version.")
        PY_LOGGER.error("Sequence[41] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[41] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[41] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
