# -*- coding: UTF-8 -*-
import traceback
import re
import util

'''
判断是否存在高密框，若存在高密框，则返回高密框的ID
'''
def isContainSAS4U_75(cli):
    cliRet = cli.execCmd("show enclosure")
    cliRetList = util.formatList(cliRet)
    encId = ""
    result = False
    for rec in cliRetList:
        if rec['Type'].find(' 75 Slot ') != -1:
            encId = rec['ID']
            result = True
            break
    
    return [result, encId]

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check SES version
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show version all")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        #Optimize check rate
        cliRet = "default"
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = py_java_env.get("showVersionAll")
        if cliRet == None or cliRet == "default":
            PY_LOGGER.info("Sequence[44] execute command: \"show version all\".")
            cliRet = cli.execCmd("show version all")
            py_java_env.put("showVersionAll", cliRet)
        PY_LOGGER.info("\nSequence[44] execute command result:\n" + cliRet)

        #Check controller ses vesion
        versionCtrTrace = []
        list1 = cliRet.splitlines()
        for field in list1:
            field = field.replace(" ", "")
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[44] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[44]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            if field.startswith("SESVersion:"):
                versionCtrTrace.append(field.replace("SESVersion:", ""))
         
        #大小排序   
        sesCtrlVersionSort = sorted(versionCtrTrace) 
        
        #判断控制器SES版本是否一致
        if 0 != len(sesCtrlVersionSort):
            if (sesCtrlVersionSort[0]!=sesCtrlVersionSort[-1]):
                flag = False 
                versionCtrlDisplay = ""
                for version in versionCtrTrace:
                    if "zh" == lang:
                        versionCtrlDisplay +=version+u"，"
                    else:
                        versionCtrlDisplay +=version+u","
                versionCtrlDisplay = versionCtrlDisplay[:-1]
                
                if "zh" == lang:
                    errMsg += u"\n控制器SES版本不一致：" + versionCtrlDisplay
                else:
                    errMsg += "\nThe SES version of controller is different: " + versionCtrlDisplay
        #Check enclosure ses vesion
        #获取是否存在高密框
        result = isContainSAS4U_75(cli)
        isCon75 = result[0]
        encId = result[1]
        version4U_SAS_75_EncTrace = []
        
        versionEncTrace = []
        list2 = cliRet.splitlines()
        str4ExpansionInCliRet = ""
        startFalg = False
        for field in list2:
            if field.startswith("Expansion"):
                startFalg = True
                continue

            if field.startswith("BBU:"):
                startFalg = False
                
            if startFalg:
                str4ExpansionInCliRet += field + "\n"
        expansionList = util.formatStr(str4ExpansionInCliRet)
        for i in range(len(expansionList)):
            str4ExpVersion = expansionList[i].get("SES Version")
            str4ExpId = expansionList[i].get("ID")
            if "" == str4ExpVersion.strip():
                flag = False
                PY_LOGGER.info("Sequence[44] inspect expSES version, get version of expSES failed")
                if "zh" == lang:
                    errMsg += u"\n级联模块（" + str4ExpId + u"）SES版本查询失败"
                else:
                    errMsg += "\nExpansion Module (" + str4ExpId + ") gets the version of SES failed"
            else:
                if True == isCon75 and str4ExpId.strip().startswith(encId):
                    version4U_SAS_75_EncTrace.append(str4ExpVersion)
                else:
                    versionEncTrace.append(str4ExpVersion)
            
        if True == isCon75:
            sesLogicVersionSort = sorted(version4U_SAS_75_EncTrace)
            if 0 != len(sesLogicVersionSort):
                if (sesLogicVersionSort[0] != sesLogicVersionSort[-1]):
                    flag = False 
                    versionEncDisplay = ""
                    for version in sesLogicVersionSort:
                        if versionEncDisplay.find(version) == -1:
                            if "zh" == lang:
                                versionEncDisplay +=version + u"，"
                            else:
                                versionEncDisplay +=version + u","
                    versionEncDisplay = versionEncDisplay[:-1]
                    
                    if "zh" == lang:
                        errMsg += u"\n高密框的级联模块SES版本不一致：" + versionEncDisplay
                    else:
                        errMsg += "\nThe SES version of expansion modules on high-density disk enclosures are inconsistent: " + versionEncDisplay
		#判断级联框SES版本是否一致
        sesEncVersionSort = sorted(versionEncTrace)
        if 0 != len(sesEncVersionSort):
            if (sesEncVersionSort[0]!=sesEncVersionSort[-1]):
                flag = False 
                versionEncDisplay = ""
                for version in versionEncTrace:
                    if versionEncDisplay.find(version) == -1:
                        if "zh" == lang:
                            versionEncDisplay +=version+u"，"
                        else:
                            versionEncDisplay +=version+u","
                versionEncDisplay = versionEncDisplay[:-1]
                
                if "zh" == lang:
                    errMsg += u"\n硬盘框的级联模块SES版本不一致：" + versionEncDisplay
                else:
                    errMsg += "\nThe SES version of expansion modules on disk enclosures are inconsistent: " + versionEncDisplay
                       
        return (flag, cliRet, errMsg)
            
    except Exception, exception:
        PY_LOGGER.error("Sequence[44] catch except of check SES version.")
        PY_LOGGER.error("Sequence[44] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[44] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[44] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
